% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unlabel.R
\name{unlabel}
\alias{unlabel}
\title{Convert labelled vectors into normal classes}
\usage{
unlabel(x)
}
\arguments{
\item{x}{data frame, which contains \code{\link[haven]{labelled}} class vectors or a single vector
of class \code{labelled}.}
}
\value{
a data frame or single vector (depending on \code{x}) with common object classes.
}
\description{
This function converts \code{\link[haven]{labelled}} class vectors
               into a generic data format, which means that simply all \code{\link[haven]{labelled}}
               class attributes will be removed, so all vectors / variables will most
               likely become \code{\link{atomic}}. Additionally, \code{tbl_df} and
               \code{tbl} class attributes will be removed from data frames, and
               a \code{\link{lbl_df}} class attribute will be added. See 'Note'.
}
\note{
This function is currently only used to avoid possible compatibility issues
        with \code{\link[haven]{labelled}} class vectors and \code{tbl_df} resp.
        \code{tbl} class attributes for data frames. Some known issues with \code{\link[haven]{labelled}}
        class vectors have already been fixed, so it might be that this function
        will become redundant in the future. Currently, data frames with \code{tbl_df} and
        \code{tbl} class attributes may cause difficulties when indexing columns
        like \code{data.frame[, colnr]} - only \code{data.frame[[colnr]]} seems
        to be safe when accessing data frame columns from within function calls.
        \cr \cr
        Data frames will be converted into labelled data frames (see \code{\link{lbl_df}}).
}
\seealso{
\href{http://www.strengejacke.de/sjPlot/datainit/}{sjPlot manual: data initialization}
}

