% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudo_r2.R
\name{cod}
\alias{cod}
\title{Tjur's Coefficient of Discrimination}
\usage{
cod(x)
}
\arguments{
\item{x}{Fitted \code{\link{glm}} or \code{\link[lme4]{glmer}} model.}
}
\value{
The \code{D} Coefficient of Discrimination, also known as
          Tjur's R-squared value.
}
\description{
This method calculates the Coefficient of Discrimination \code{D}
               for generalized linear (mixed) models for binary data. It is
               an alternative to other Pseudo-R-squared values
               like Nakelkerke's R2 or Cox-Snell R2.
}
\note{
The Coefficient of Discrimination \code{D} can be read like any
        other (Pseudo-)R-squared value.
}
\examples{
data(efc)

# Tjur's R-squared value
efc$services <- dicho(efc$tot_sc_e, "v", 0, as.num = TRUE)
fit <- glm(services ~ neg_c_7 + c161sex + e42dep,
           data = efc,
           family = binomial(link = "logit"))
cod(fit)

}
\references{
Tjur T (2009) Coefficients of determination in logistic regression models -
              a new proposal: The coefficient of discrimination. The American Statistician,
              63(4): 366-372
}
\seealso{
\code{\link{r2}} for Nagelkerke's and Cox and Snell's pseudo
           r-squared coefficients.
}

