% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_labels.R
\name{var_labels}
\alias{var_labels}
\title{Add variable label(s) to variables}
\usage{
var_labels(data, ...)
}
\arguments{
\item{data}{A data frame.}

\item{...}{Pairs of named vectors, where the name equals the variable name,
which should be labelled, and the value is the new variable label.}
}
\value{
\code{data}, with variable label attribute(s) for those variables
          specified in \code{...}.
}
\description{
This function adds variable labels as label-attribute
               (named \emph{"label"}) to a set of variables in a
               data frame. Unlike \code{\link{set_label}}, this
               function takes several pairs of named vectors as input to change
               multiple variable labels in a data frame at once.
               \cr \cr
               Furthermore, since the first argument is a data frame and multiple
               variables can be passed as arguments, this function fits nicely
               into a pipe-workflow.
}
\examples{
library(dplyr)

# Set variable labels for data frame
dummy <- data.frame(a = sample(1:4, 10, replace = TRUE),
                    b = sample(1:4, 10, replace = TRUE),
                    c = sample(1:4, 10, replace = TRUE))

dummy \%>\%
  var_labels(a = "First variable", c = "third variable") \%>\%
  get_label()

}

