% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row_sums.R
\name{row_sums}
\alias{row_sums}
\alias{row_means}
\title{Row sums and means for data frames}
\usage{
row_sums(x, ..., na.rm = TRUE, var = "rowsums", append = FALSE)

row_means(x, ..., n, var = "rowmeans", append = FALSE)
}
\arguments{
\item{x}{A vector or data frame.}

\item{...}{Optional, unquoted names of variables that should be selected for
further processing. Required, if \code{x} is a data frame (and no
vector) and only selected variables from \code{x} should be processed.
You may also use functions like \code{:} or dplyr's \code{\link[dplyr]{select_helpers}}.
The latter must be stated as formula (i.e. beginning with \code{~}).
See 'Examples' or \href{../doc/design_philosophy.html}{package-vignette}.}

\item{na.rm}{Logical, \code{TRUE} if missing values should be omitted from
the calculations.}

\item{var}{Name of new the variable with the row sums or means.}

\item{append}{Logical, if \code{TRUE} and \code{x} is a data frame,
\code{x} including the new variables as additional columns is returned;
if \code{FALSE} (the default), only the new variables are returned.}

\item{n}{May either be
\itemize{
  \item a numeric value that indicates the amount of valid values per row to calculate the row mean;
  \item or a value between 0 and 1, indicating a proportion of valid values per row to calculate the row mean (see 'Details').
}
If a row's sum of valid values is less than \code{n}, \code{NA} will be returned as row mean value.}
}
\value{
For \code{row_sums()}, a tibble with one variable: the row sums from
        \code{x}; for \code{row_means()}, a tibble with one variable: the row
        means from \code{x}.
}
\description{
\code{row_sums()} simply wraps \code{\link{rowSums}}, while
             \code{row_means()} simply wraps \code{\link[sjstats]{mean_n}},
             however, the argument-structure of both functions is designed
             to work nicely within a pipe-workflow and allows select-helpers
             for selecting variables, the default for \code{na.rm} is \code{TRUE},
             and the return value is always a tibble (with one variable).
}
\details{
For \code{n}, must be a numeric value from \code{0} to \code{ncol(x)}. If
         a \emph{row} in \code{x} has at least \code{n} non-missing values, the
         row mean is returned. If \code{n} is a non-integer value from 0 to 1,
         \code{n} is considered to indicate the proportion of necessary non-missing
         values per row. E.g., if \code{n = .75}, a row must have at least \code{ncol(x) * n}
         non-missing values for the row mean to be calculated. See 'Examples'.
}
\examples{
data(efc)
efc \%>\% row_sums(c82cop1:c90cop9)

library(dplyr)
row_sums(efc, ~contains("cop"))

dat <- data.frame(
  c1 = c(1,2,NA,4),
  c2 = c(NA,2,NA,5),
  c3 = c(NA,4,NA,NA),
  c4 = c(2,3,7,8),
  c5 = c(1,7,5,3)
)
dat

row_means(dat, n = 4)
row_means(dat, c1:c4, n = 4)
# at least 40\% non-missing
row_means(dat, c1:c4, n = .4)

# create sum-score of COPE-Index, and append to data
efc \%>\%
  select(c82cop1:c90cop9) \%>\%
  row_sums() \%>\%
  add_columns(efc)

}
