% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ref_lvl.R
\name{ref_lvl}
\alias{ref_lvl}
\title{Change reference level of (numeric) factors}
\usage{
ref_lvl(x, ..., lvl = NULL)
}
\arguments{
\item{x}{A vector or data frame.}

\item{...}{Optional, unquoted names of variables that should be selected for
further processing. Required, if \code{x} is a data frame (and no
vector) and only selected variables from \code{x} should be processed.
You may also use functions like \code{:} or tidyselect's
\code{\link[tidyselect]{select_helpers}}.
See 'Examples' or \href{../doc/design_philosophy.html}{package-vignette}.}

\item{lvl}{Eiher numeric, indicating the new reference level, or a string,
indicating the value label from the new reference level. If \code{x} is a
factor with non-numeric factor levels, \code{relevel(x, ref = lvl)} is
returned. See 'Examples'.}
}
\value{
\code{x} with new reference level. If \code{x}
          is a data frame, the complete data frame \code{x} will be returned,
          where variables specified in \code{...} will be re-leveled;
          if \code{...} is not specified, applies to all variables in the
          data frame.
}
\description{
Changes the reference level of (numeric) factor.
}
\details{
Unlike \code{\link[stats]{relevel}}, this function behaves differently
  for factor with numeric factor levels or for labelled data, i.e. factors
  with value labels for the values. \code{ref_lvl()} changes the reference
  level by recoding the factor's values using the \code{\link{rec}} function.
  Hence, all values from lowest up to the reference level indicated by
  \code{lvl} are recoded, with \code{lvl} starting as lowest factor value.
  For factors with non-numeric factor levels, the function simply returns
  \code{relevel(x, ref = lvl)}. See 'Examples'.
}
\examples{
data(efc)
x <- to_factor(efc$e42dep)
str(x)
frq(x)

# see column "val" in frq()-output, which indicates
# how values/labels were recoded after using ref_lvl()
x <- ref_lvl(x, lvl = 3)
str(x)
frq(x)

library(dplyr)
dat <- efc \%>\%
  select(c82cop1, c83cop2, c84cop3) \%>\%
  to_factor()

frq(dat)
ref_lvl(dat, c82cop1, c83cop2, lvl = 2) \%>\% frq()

# compare numeric and string value for "lvl"-argument
x <- to_factor(efc$e42dep)
frq(x)
ref_lvl(x, lvl = 2) \%>\% frq()
ref_lvl(x, lvl = "slightly dependent") \%>\% frq()

# factors with non-numeric factor levels
data(iris)
levels(iris$Species)
levels(ref_lvl(iris$Species, lvl = 3))
levels(ref_lvl(iris$Species, lvl = "versicolor"))

}
\seealso{
\code{\link{to_factor}} to convert numeric vectors into factors;
           \code{\link{rec}} to recode variables.
}
