% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/std_beta.R
\name{std_beta}
\alias{std_beta}
\alias{std_beta.merMod}
\alias{std_beta.lm}
\alias{std_beta.gls}
\title{Standardized beta coefficients and CI of linear and mixed models}
\usage{
std_beta(fit, ...)

\method{std_beta}{merMod}(fit, ci.lvl = 0.95, ...)

\method{std_beta}{lm}(fit, type = "std", ci.lvl = 0.95, ...)

\method{std_beta}{gls}(fit, type = "std", ci.lvl = 0.95, ...)
}
\arguments{
\item{fit}{Fitted linear (mixed) model of class \code{lm}, \code{merMod}
(\CRANpkg{lme4} package), \code{gls} or \code{stanreg}.}

\item{...}{Currently not used.}

\item{ci.lvl}{Numeric, the level of the confidence intervals.}

\item{type}{If \code{fit} is of class \code{lm}, normal standardized coefficients
are computed by default. Use \code{type = "std2"} to follow
\href{http://www.stat.columbia.edu/~gelman/research/published/standardizing7.pdf}{Gelman's (2008)}
suggestion, rescaling the estimates by deviding them by two standard
deviations, so resulting coefficients are directly comparable for
untransformed binary predictors.}
}
\value{
A \code{tibble} with term names, standardized beta coefficients,
          standard error and confidence intervals of \code{fit}.
}
\description{
Returns the standardized beta coefficients, std. error and confidence intervals
               of a fitted linear (mixed) models.
}
\details{
\dQuote{Standardized coefficients refer to how many standard deviations a dependent variable will change,
        per standard deviation increase in the predictor variable. Standardization of the coefficient is
        usually done to answer the question of which of the independent variables have a greater effect
        on the dependent variable in a multiple regression analysis, when the variables are measured
        in different units of measurement (for example, income measured in dollars and family size
        measured in number of individuals)} \cite{(Source: Wikipedia)}
}
\note{
For \code{\link[nlme]{gls}}-objects, standardized beta coefficients may be wrong
        for categorical variables (\code{factors}), because the \code{model.matrix} for
        \code{gls} objects returns the original data of the categorical vector,
        and not the 'dummy' coded vectors as for other classes. See, as example: \cr \cr
        \code{head(model.matrix(lm(neg_c_7 ~ as.factor(e42dep), data = efc, na.action = na.omit)))}
        \cr \cr and \cr \cr
        \code{head(model.matrix(nlme::gls(neg_c_7 ~ as.factor(e42dep), data = efc, na.action = na.omit)))}.
        \cr \cr
        In such cases, use \code{\link[sjmisc]{to_dummy}} to create dummies from
        factors.
}
\examples{
# fit linear model
fit <- lm(Ozone ~ Wind + Temp + Solar.R, data = airquality)
# print std. beta coefficients
std_beta(fit)

# print std. beta coefficients and ci, using
# 2 sd and center binary predictors
std_beta(fit, type = "std2")

# std. beta for mixed models
library(lme4)
fit1 <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)
std_beta(fit)

}
\references{
\href{http://en.wikipedia.org/wiki/Standardized_coefficient}{Wikipedia: Standardized coefficient}
            \cr \cr
            Gelman A. 2008. Scaling regression inputs by dividing by two standard deviations. Statistics in Medicine 27: 2865-2873 \url{http://www.stat.columbia.edu/~gelman/research/published/standardizing7.pdf}
}
