% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_ci.R
\name{boot_ci}
\alias{boot_ci}
\alias{boot_p}
\alias{boot_se}
\title{Standard Error and Confidence Intervals for bootstrapped estimates}
\usage{
boot_ci(data, x)

boot_se(data, x)

boot_p(data, x)
}
\arguments{
\item{data}{A data frame that containts the vector with bootstrapped
estimates, or directly the vector (see 'Examples').}

\item{x}{Name of the variable with bootstrapped estimates. Required, if
\code{data} is a data frame and no vector.}
}
\value{
The bootstrap standard error, the lower and upper confidence
        intervals or the p-value of the bootstrapped estimates.
}
\description{
Compute bootstrap standard error, confidence intervals and
             p-value for a vector of bootstrap replicate estimates.
}
\details{
This method requires a vector of bootstrap replicate estimates
         as input. The function then computes the bootstrap standard error
         by calculating the standard deviation of the input vector. The mean
         value of the input vector is used to calculate the lower and upper
         confidence interval, assuming a t-distribution of bootstrap estimate
         replicates.
}
\examples{
data(efc)
bs <- bootstrap(efc, 100)

# now run models for each bootstrapped sample
bs$models <- lapply(bs$strap, function(x) lm(neg_c_7 ~ e42dep + c161sex, data = x))

# extract coefficient "dependency" from each model
bs$dependency <- unlist(lapply(bs$models, function(x) coef(x)[2]))

# get bootstrapped confidence intervals
boot_ci(bs$dependency)

# compare with model fit
fit <- lm(neg_c_7 ~ e42dep + c161sex, data = efc)
confint(fit)[2, ]

# compare coefficients
mean(bs$dependency)
coef(fit)[2]

# bootstrap() and boot_ci() work fine within pipe-chains
library(dplyr)
efc \%>\%
  bootstrap(100) \%>\%
  mutate(models = lapply(.$strap, function(x) {
    lm(neg_c_7 ~ e42dep + c161sex, data = x)
  })) \%>\%
  mutate(dependency = unlist(lapply(.$models, function(x) coef(x)[2]))) \%>\%
  boot_ci(dependency)


# extract coefficient "gender" from each model
bs$gender <- unlist(lapply(bs$models, function(x) coef(x)[3]))

# check p-value
boot_p(bs$gender)
summary(fit)$coefficients[3, ]

}
\seealso{
\code{\link{bootstrap}} to genearte bootstrap samples.
}

