% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peaks.R
\name{ppeak}
\alias{ppeak}
\title{Cumulative distribution function of number of peaks in a random series}
\usage{
ppeak(n, k, upper = TRUE, usedata = TRUE)
}
\arguments{
\item{n}{A positive integer representing the number of observations in the
series.}

\item{k}{An integer or a sequence of integers strictly incrementing by 1,
with all values between 0 and \code{n - 1} inclusive. Represents the
number of peaks in the series.}

\item{upper}{A logical. Should upper tailed cumulative probability be
calculated? Defaults to \code{TRUE} due to function being designed
primarily for calculating \eqn{p}-values for the peaks test. Note that
both upper and lower tailed cumulative probabilities are computed
inclusive of \code{k}.}

\item{usedata}{A logical. Should probability mass function values be
read from \code{\link{dpeakdat}} rather than computing them from
\code{\link{dpeak}}? This option will save significantly on
computation time if \eqn{n < 170} but is currently only available
for \eqn{n \leq 500}.}
}
\value{
A double between 0 and 1 representing the probability of at least
   (at most) k peaks occurring in a series of \eqn{n} independent and
   identically distributed continuous random variables.
}
\description{
This function computes \eqn{\sum_{k} P(n,k)}, i.e. the probability that a
series of \eqn{n} independent and identically distributed random variables
contains \eqn{\ge k} \eqn{(\le k)} peaks, with peaks as defined in
\insertCite{Goldfeld65;textual}{skedastic}. The function may be used to
compute \eqn{p}-values for the Goldfeld-Quandt nonparametric test for
heteroskedasticity in a linear model. Computation time is very slow for
\eqn{n > 170} if \code{usedata} is set to \code{FALSE}.
}
\examples{
# For an independent sample of size 250, the probability of at least 10
# peaks is 0.06186582
ppeak(250, 10, upper = TRUE, usedata = TRUE)
# For an independent sample of size 10, the probability of at most 2 peaks
# is 0.7060615
ppeak(10, 2, upper = FALSE, usedata = FALSE)

}
\references{
{\insertAllCited{}}
}
\seealso{
\code{\link{dpeak}}, \code{\link{goldfeld_quandt}}
}
