% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rackauskas_zuokas.R
\name{rackauskas_zuokas}
\alias{rackauskas_zuokas}
\title{Rackauskas-Zuokas Test for Heteroskedasticity in a Linear Regression Model}
\usage{
rackauskas_zuokas(
  mainlm,
  alpha = 0,
  pvalmethod = c("data", "sim"),
  R = 2^14,
  m = 2^17,
  sqZ = FALSE,
  seed = 1234,
  statonly = FALSE
)
}
\arguments{
\item{mainlm}{Either an object of \code{\link[base]{class}} \code{"lm"}
(e.g., generated by \code{\link[stats]{lm}}), or
a list of two objects: a response vector and a design matrix. The objects
are assumed to be in that order, unless they are given the names
\code{"X"}  and \code{"y"} to distinguish them. The design matrix passed
in a list must begin with a column of ones if an intercept is to be
included in the linear model. The design matrix passed in a list should
not contain factors, as all columns are treated 'as is'. For tests that
use ordinary least squares residuals, one can also pass a vector of
residuals in the list, which should either be the third object or be
named \code{"e"}.}

\item{alpha}{A double such that \eqn{0 \le \alpha < 1/2}; a hyperparameter
of the test. Defaults to 0.}

\item{pvalmethod}{A character, either \code{"data"} or \code{"sim"},
determining which method to use to compute the empirical
\eqn{p}-value. If \code{"data"}, the dataset \code{\link{T_alpha}}
consisting of pre-generated Monte Carlo replicates from the
asymptotic null distribution of the test statistic is loaded and used to
compute empirical \eqn{p}-value. This is only available for certain
values of \code{alpha}, namely \eqn{i/32} where \eqn{i=0,1,\ldots,15}.
If \code{"sim"}, Monte Carlo replicates are generated from the
asymptotic null distribution. Partial matching is used.}

\item{R}{An integer representing the number of Monte Carlo replicates to
generate, if \code{pvalmethod == "sim"}. Ignored if
\code{pvalmethod == "data"}.}

\item{m}{An integer representing the number of standard normal variates to
use when generating the Brownian Bridge for each replicate, if
\code{pvalmethod == "sim"}. Ignored if \code{pvalmethod == "data"}. If
number of observations is small,
\insertCite{Rackauskas07;textual}{skedastic} recommends using \eqn{m=n}.
The dataset \code{\link{T_alpha}} used \eqn{m=2^17} which is
computationally intensive.}

\item{sqZ}{A logical. If \code{TRUE}, the standard normal variates used
in the Brownian Bridge when generating from the asymptotic null
distribution are first squared, i.e. transformed to \eqn{\chi^2(1)}
variates. This is recommended by
\insertCite{Rackauskas07;textual}{skedastic} when the number of
observations is small. Ignored if \code{pvalmethod == "data"}.}

\item{seed}{An integer representing the seed to be used for pseudorandom
number generation when simulating values from the asymptotic null
distribution. This is to provide reproducibility of test results.
Ignored if \code{pvalmethod == "data"}. If user does not wish to set
the seed, pass \code{NA}.}

\item{statonly}{A logical. If \code{TRUE}, only the test statistic value
is returned, instead of an object of \code{\link[base]{class}}
\code{"htest"}. Defaults to \code{FALSE}.}
}
\value{
An object of \code{\link[base]{class}} \code{"htest"}. If object is
   not assigned, its attributes are displayed in the console as a
   \code{\link[tibble]{tibble}} using \code{\link[broom]{tidy}}.
}
\description{
This function implements the two methods of
   \insertCite{Rackauskas07;textual}{skedastic} for testing for heteroskedasticity
   in a linear regression model.
}
\details{
Rackauskas and Zuokas propose a class of tests that entails determining the
   largest weighted difference in variance of estimated error. The
   asymptotic behaviour of their test statistic \eqn{T_{n,\alpha}} is
   studied using the empirical polygonal process constructed from partial
   sums of the squared residuals. The test is right-tailed.
}
\examples{
mtcars_lm <- lm(mpg ~ wt + qsec + am, data = mtcars)
rackauskas_zuokas(mtcars_lm)
rackauskas_zuokas(mtcars_lm, alpha = 7 / 16)
\donttest{
n <- length(mtcars_lm$residuals)
rackauskas_zuokas(mtcars_lm, pvalmethod = "sim", m = n, sqZ = TRUE)
}

}
\references{
{\insertAllCited{}}
}
