% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface-compile.R
\name{compile_r}
\alias{compile_r}
\title{Compile an R file into a JavaScript file}
\usage{
compile_r(
  input,
  output = "",
  rules = default_rules(),
  deparsers = default_deparsers()
)
}
\arguments{
\item{input}{A character string; the input file.}

\item{output}{A character string; the output file. When the
output is "", the result is printed to the standard output.}

\item{rules}{A list of rewriting rules. See \link{make_rule} for more detail.}

\item{deparsers}{A list of deparsers. See \link{make_deparser} for more detail.}
}
\value{
A character string; the output file path.
}
\description{
Compile an R file into a JavaScript file
}
\examples{
file <- system.file("test_files/test_source.R", package = "sketch")
readLines(file)
compile_r(input = file)

}
