% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-rewrite.R
\name{rewrite}
\alias{rewrite}
\title{Interface for AST rewriting}
\usage{
rewrite(ast, rules)
}
\arguments{
\item{ast}{A language object.}

\item{rules}{A list of functions, each of which is the output from `make_rule`.}
}
\value{
A language object.
}
\description{
Interface for AST rewriting
}
\examples{
library(sketch)

rewrite(
  ast = rlang::parse_expr("2 * (3 + pi)"),
  rules = list(make_rule("pi", "Math.PI"))
)

rewrite(
  ast = rlang::parse_expr("2 + pi"),
  rules = list(
    make_rule("pi", "Math.PI"),
    make_rule("+", "Math.add")
  )
)

}
