% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshape.R
\name{focus}
\alias{focus}
\title{Only show a subset of summary statistics after skimming}
\usage{
focus(.data, ...)
}
\arguments{
\item{.data}{A \code{skim_df} object.}

\item{...}{One or more unquoted expressions separated by commas.
You can treat variable names like they are positions, so you can
use expressions like \code{x:y} to select ranges of variables.

Positive values select variables; negative values drop variables.
If the first expression is negative, \code{select()} will automatically
start with all variables.

Use named arguments, e.g. \code{new_name = old_name}, to rename selected variables.

The arguments in \code{...} are automatically \link[rlang:quo]{quoted} and
\link[rlang:eval_tidy]{evaluated} in a context where column names
represent column positions. They also support
\link[rlang:quasiquotation]{unquoting} and splicing. See
\code{vignette("programming")} for an introduction to these concepts.

See \link[tidyselect:select_helpers]{select helpers} for more details and
examples about tidyselect helpers such as \code{starts_with()}, \code{everything()}, ...}
}
\description{
This function is a variant of \code{\link[dplyr:select]{dplyr::select()}} designed to work with
\code{skim_df} objects. When using \code{focus()}, \code{skimr} metadata columns are kept,
and \code{skimr} print methods are still utilized. Otherwise, the signature and
behavior is identical to \code{\link[dplyr:select]{dplyr::select()}}.
}
\examples{
# Compare
iris \%>\%
  skim() \%>\%
  dplyr::select(n_missing)

iris \%>\%
  skim() \%>\%
  focus(n_missing)

# This is equivalent to
iris \%>\%
  skim() \%>\%
  dplyr::select(skim_variable, skim_type, n_missing)
}
