% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfl.R
\name{sfl}
\alias{sfl}
\title{Create a skimr function list}
\usage{
sfl(..., skim_type = "")
}
\arguments{
\item{...}{Inherited from dplyr::data_masking() for dplyr version 1 or later
or dplyr::funs() for older versions of dplyr.
A list of functions
specified by:
\itemize{
\item Their name, \code{"mean"}
\item The function itself, \code{mean}
\item A call to the function with \code{.} as a dummy argument,
\code{mean(., na.rm = TRUE)}
\item An anonymous function in \pkg{purrr} notation, \code{~mean(., na.rm = TRUE)}
}}

\item{skim_type}{A character scalar. This is used to match locally-provided
skimmers with defaults. See \code{\link[=get_skimmers]{get_skimmers()}} for more detail.}
}
\value{
A \code{skimr_function_list}, which contains a list of \code{fun_calls},
returned by \code{dplyr::funs()} and a list of skimming functions to drop.
}
\description{
This constructor is used to create a named list of functions. It also you
also pass \code{NULL} to identify a skimming function that you wish to remove.
Only functions that return a single value, working with \code{\link[dplyr:summarise]{dplyr::summarize()}},
can be used within \code{sfl}.
}
\details{
\code{sfl()} will automatically generate callables and names for a variety of
inputs, including functions, formulas and strings. Nonetheless, we recommend
providing names when reasonable to get better \code{\link[=skim]{skim()}} output.
}
\examples{
# sfl's can take a variety of input formats and will generate names
# if not provided.
sfl(mad, "var", ~ length(.)^2)

# But these can generate unpredictable names in your output.
# Better to set your own names.
sfl(mad = mad, variance = "var", length_sq = ~ length(.)^2)

# sfl's can remove individual skimmers from defaults by passing NULL.
sfl(hist = NULL)

# When working interactively, you don't need to set a type.
# But you should when defining new defaults with `get_skimmers()`.
get_skimmers.my_new_class <- function(column) {
  sfl(n_missing, skim_type = "my_new_class")
}
}
\seealso{
\code{\link[dplyr:funs]{dplyr::funs()}}, \code{\link[=skim_with]{skim_with()}} and \code{\link[=get_skimmers]{get_skimmers()}}.
}
