% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshape.R
\name{focus}
\alias{focus}
\title{Only show a subset of summary statistics after skimming}
\usage{
focus(.data, ...)
}
\arguments{
\item{.data}{A \code{skim_df} object.}

\item{...}{One or more unquoted expressions separated by commas. Variable
names can be used as if they were positions in the data frame, so
expressions like x:y can be used to select a range of variables.}
}
\description{
This function is a variant of \code{\link[dplyr:select]{dplyr::select()}} designed to work with
\code{skim_df} objects. When using \code{focus()}, \code{skimr} metadata columns are kept,
and \code{skimr} print methods are still utilized. Otherwise, the signature and
behavior is identical to \code{\link[dplyr:select]{dplyr::select()}}.
}
\examples{
# Compare
iris |>
  skim() |>
  dplyr::select(n_missing)

iris |>
  skim() |>
  focus(n_missing)

# This is equivalent to
iris |>
  skim() |>
  dplyr::select(skim_variable, skim_type, n_missing)
}
