% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeltime_wfs_bestmodel.R
\name{modeltime_wfs_bestmodel}
\alias{modeltime_wfs_bestmodel}
\title{Modeltime best workflow from a set of models}
\usage{
modeltime_wfs_bestmodel(
  .wfs_results,
  .model = NULL,
  .metric = "rmse",
  .minimize = TRUE
)
}
\arguments{
\item{.wfs_results}{a tibble generated from the \code{modeltime_wfs_fit()} function.}

\item{.model}{string or number, It can be supplied as follows: “top n,” “Top n” or “tOp n”, where n is the number
of best models to select; n, where n is the number of best models to select; name of the
workflow or workflows to select.}

\item{.metric}{metric to get best model from ('mae', 'mape','mase','smape','rmse','rsq')}

\item{.minimize}{a boolean indicating whether to minimize (TRUE) or maximize (FALSE) the metric.}
}
\value{
a tibble containing the best model based on the selected metric.
}
\description{
get best workflows generated from the \code{modeltime_wfs_fit()} function output.
}
\details{
the best model is selected based on a specific metric ('mae', 'mape','mase','smape','rmse','rsq').
The default is to minimize the metric. However, if the model is being selected based on rsq
minimize should be FALSE.
}
\examples{
library(dplyr)
library(earth)
data <- sknifedatar::data_avellaneda \%>\% mutate(date=as.Date(date)) \%>\% filter(date<'2012-06-01')

recipe_date <- recipes::recipe(value ~ ., data = data) \%>\% 
  recipes::step_date(date, features = c('dow','doy','week','month','year')) 

mars <- parsnip::mars(mode = 'regression') \%>\%
  parsnip::set_engine('earth')

wfsets <- workflowsets::workflow_set(
  preproc = list(
    R_date = recipe_date),
  models  = list(M_mars = mars),
  cross   = TRUE)

wffits <- sknifedatar::modeltime_wfs_fit(.wfsets = wfsets, 
                                         .split_prop = 0.8, 
                                         .serie=data)

sknifedatar::modeltime_wfs_bestmodel(.wfs_results = wffits,
                                     .metric='rsq',
                                     .minimize = FALSE)
                                  
}
