% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeltime_wfs_multifit.R
\name{modeltime_wfs_multifit}
\alias{modeltime_wfs_multifit}
\title{Fit a workflow_set object over multiple time series}
\usage{
modeltime_wfs_multifit(serie, .prop, .wfs)
}
\arguments{
\item{serie}{nested time series.}

\item{.prop}{series train/test partition ratio.}

\item{.wfs}{worklows_set object.}
}
\value{
A list of 2 items. The first component is a tibble with a first column that contains the
name of the series, and a second column called 'nested_column' that stores the time series,
then a column for each workflow for each series are stored.
The last 2 columns, 'nested_model' and 'calibration', store the 'n' trained workflows for each
series and the adjustment metrics on the test partition.
The second element is a tibble saved with the name of 'models_accuracy', it allows to visualize
the performance of each workflow for each series according to a set of metrics.
}
\description{
allows a workflow_set object to be fitted over multiple time series, using models
from the 'modeltime' package.
}
\examples{
library(dplyr)
library(earth)

df <- sknifedatar::emae_series

datex <- '2020-02-01'
df_emae <- df \%>\%
dplyr::filter(date <= datex) \%>\% 
tidyr::nest(nested_column=-sector) \%>\% 
head(2)

receta_base <- recipes::recipe(value ~ ., data = df \%>\% select(-sector))

mars <- parsnip::mars(mode = 'regression') \%>\% parsnip::set_engine('earth')

wfsets <- workflowsets::workflow_set(
  preproc = list(
    R_date = receta_base),
  models  = list(M_mars = mars),
  cross   = TRUE)

sknifedatar::modeltime_wfs_multifit(.wfs = wfsets,
                                    .prop = 0.8, 
                                    serie = df_emae)

}
