% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netDir.R
\name{make_net_dir}
\alias{make_net_dir}
\title{Directed network}
\usage{
make_net_dir(x, disp = FALSE, alpha = 0.003, cap = FALSE, pct = 10,
  carrier = FALSE, metro = FALSE)
}
\arguments{
\item{x}{Data frame}

\item{disp}{Uses the Serrano's disparity filter (\url{https://en.wikipedia.org/wiki/Disparity_filter_algorithm_of_weighted_network})
to extract the backbone of the network.}

\item{alpha}{Argument for disparity filter.}

\item{cap}{Filters original data based on the edge weight.}

\item{pct}{Argument for cap filter. Value should be imput as percentage.}

\item{carrier}{Groups data per carrier and OD}

\item{metro}{Groups data by metropolitan area}
}
\description{
Generates Directed Network with an iGraph \strong{gDir} object,
a Data Frame \strong{netDir} and a Data Frame
with Airport/Nodes statistics \strong{nodes}.
}
\examples{
\dontrun{
make_net_dir(OD_Sample)

# Apply Disparity Filter
make_net_dir(OD_Sample, disp = TRUE, alpha = 0.05)

# Apply Percentage Cap
make_net_dir(OD_Sample, cap = TRUE, pct = 20)
}
}
