% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slackr_csv.R
\name{slackr_csv}
\alias{slackr_csv}
\title{Send a data frame to Slack as a CSV}
\usage{
slackr_csv(
  data,
  filename = tempfile(fileext = ".csv"),
  title = NULL,
  initial_comment = NULL,
  channels = Sys.getenv("SLACK_CHANNEL"),
  token = Sys.getenv("SLACK_TOKEN"),
  thread_ts = NULL,
  ...
)
}
\arguments{
\item{data}{the data frame or tibble to upload.}

\item{filename}{the file to save to. Defaults to a tempfile. Using the default is \emph{highly} advised, as using a non-tempfile will write a file that persists on the disk (either in the working directory, or at the location specified).}

\item{title}{Title of file.}

\item{initial_comment}{The message text introducing the file in specified channels.}

\item{channels}{Comma-separated list of channel names or IDs where the file will be shared.}

\item{token}{Authentication token bearing required scopes.}

\item{thread_ts}{Provide another message's ts value to upload this file as a reply. Never use a reply's ts value; use its parent instead.}

\item{...}{additional arguments to be passed to \code{write.csv()}.}
}
\value{
\code{httr} response object from \code{POST} call (invisibly)

\code{httr} response object from \code{POST} call (invisibly)
}
\description{
\code{slackr_csv} simplifies the process of sending a data frame to Slack as a CSV file.
It is highly recommended to leave the \code{filename} argument as the default (tempfile), as changing it will persist a csv file in your working directory.
}
\seealso{
\code{\link[=slackr_upload]{slackr_upload()}}
}
\author{
Matt Kaye (aut)
}
