% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slackr_history.R
\name{slackr_history}
\alias{slackr_history}
\title{Reads history of a channel.}
\usage{
slackr_history(
  message_count,
  channel = Sys.getenv("SLACK_CHANNEL"),
  token = Sys.getenv("SLACK_TOKEN"),
  posted_to_time = as.numeric(Sys.time()),
  duration = NULL,
  posted_from_time = 0,
  paginate = FALSE,
  inclusive = TRUE
)
}
\arguments{
\item{message_count}{The number of messages to retrieve (only when \code{paginate = FALSE}).
Corresponds to \code{limit} in the \href{https://api.slack.com/methods/conversations.history}{conversations.history} docs.
Note: If using pagination, setting a value of (e.g.) 1 will result in paginating
through the channel's history one message at a time. Slack recommends using a value of 200.}

\item{channel}{Channel, private group, or IM channel to send message to. Can be an encoded ID, or a name.}

\item{token}{Authentication token bearing required scopes.}

\item{posted_to_time}{Timestamp of the last post to consider.
Corresponds to \code{latest} in the \href{https://api.slack.com/methods/conversations.history}{conversations.history} docs.
Default: current time.}

\item{duration}{Number of hours of history to retrieve.  If neither \code{duration}
nor \code{posted_from_time} is specified, there is no time limit on the retrieved
history. (default: \code{NULL})}

\item{posted_from_time}{Timestamp of the first post time to consider. If both
posted_to_time and duration is specifed, they take precedence.
Corresponds to \code{oldest} in the \href{https://api.slack.com/methods/conversations.history}{conversations.history}
docs.
Default: 0}

\item{paginate}{If TRUE, uses the Slack API pagination mechanism, and will retrieve all history inside the timeframe.  Otherwise, makes a single call to the API and retrieves a maximum of \code{message_count} messages.}

\item{inclusive}{Include messages with oldest or latest timestamps in results. Ignored unless either timestamp is specified.}
}
\value{
A \code{tibble} with message metadata
}
\description{
Returns a dataframe of post history in a channel.
}
\section{Scopes}{


You need one or more of these scopes enabled in your slack app: *
channels:history * groups:history * im:history * mpim:history
}

\references{
\url{https://api.slack.com/methods/conversations.history}
}
