% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{param}
\alias{param}
\alias{param.slca}
\title{Printing Estimated Parameters of \code{slca} Object}
\usage{
param(object, ...)

\method{param}{slca}(
   object, type = c("probs", "logit"),
   se = FALSE, index = FALSE, ...
)
}
\arguments{
\item{object}{an object of class \code{slca} and \code{estimated}.}

\item{...}{additional arguments.}

\item{type}{a character string specifying the format in which the estimated parameters should be displayed. The options are \code{"probs"} for probability format or \code{"logit"} for log-odds (logit) format. The default setting is \code{"probs"}.}

\item{se}{a logical indicating whether standard errors (TRUE) or parameter estimates (FALSE) should be displayed.}

\item{index}{a logical indicating whether to include (\code{TRUE}) or exclude (\code{FALSE}) the indices of the estimated parameters in the output.}
}
\value{
A \code{list} containing the specified estimated parameters or their standard errors if \code{se} is set to \code{TRUE}. The components of the list include:
\item{pi}{Membership probabilities of the root variable.}
\item{tau}{Conditional probabilities between latent class variables, represented with uppercase alphabets for considering measurement invariance.}
\item{rho}{Item response probabilities for each measurement model, represented with lowercase alphabets for considering measurement invariance.}
}
\description{
This function prints the estimated parameters of the \code{slca} model by accepting an \code{estimated} \code{slca} object.
}
