#' Gather League Data
#'
#' Given a league ID, grab the data for that league. Includes roster positions, season type, if it is in
#' season, and more.
#'
#' @return Returns a list containing information about the league.
#' @author Nick Bultman, \email{njbultman74@@gmail.com}, September 2021
#' @keywords user users
#' @importFrom httr GET content
#' @importFrom jsonlite fromJSON
#' @export
#' @examples
#' \dontrun{get_league(688281863499907072)}
#'
#' @param league_id League ID generated by Sleeper (numeric or character)
#'
get_league <- function(league_id) {
  # Execute query to API given league ID specified
  x <- jsonlite::fromJSON(httr::content(httr::GET(paste0("https://api.sleeper.app/v1/league/", league_id)), as = "text"))
  # Check if returned object is NULL
  if(is.null(x)) {
    # If NULL, inform user and return nothing
    message("League ID did not return any results. Did you enter the league ID correctly?")
  } else {
    # If not NULL, return object (list)
    return(x)
  }
}
