#' Gather Winner Playoff Bracket
#'
#' Given a league ID, get the winner playoff bracket for the league.
#'
#' @return Returns a data frame containing playoff information for the winner bracket.
#' @author Nick Bultman, \email{njbultman74@@gmail.com}, December 2021
#' @keywords league playoff winner
#' @importFrom httr GET content
#' @importFrom jsonlite fromJSON
#' @export
#' @examples
#' \dontrun{get_winner_playoff_bracket(688281863499907072)}
#'
#' @param league_id League ID generated by Sleeper (numeric or character)
#'
get_winner_playoff_bracket <- function(league_id) {
  # Execute query to API given league ID specified
  x <- jsonlite::fromJSON(httr::content(httr::GET(paste0("https://api.sleeper.app/v1/league/", league_id, "/winners_bracket")), as = "text"))
  # Check if returned object is NULL
  if(is.null(x)) {
    # If NULL, inform the user and return nothing
    message("League ID did not return any results. Did you enter the league ID correctly?")
  } else {
    # If not NULL, return the data frame
    return(x)
  }
}
