#' Gather League Trades
#'
#' Given a league ID, grab the trades that have occured.
#'
#' @return Returns a list containing trades.
#' @author Nick Bultman, \email{njbultman74@@gmail.com}, September 2021
#' @keywords league trades
#' @importFrom httr GET content
#' @importFrom jsonlite fromJSON
#' @export
#' @examples
#' \dontrun{get_traded_picks(688281863499907072)}
#'
#' @param league_id League ID generated by Sleeper (numeric or character)
#'
get_traded_picks <- function(league_id) {
  # Execute query to API given league ID specified
  x <- jsonlite::fromJSON(httr::content(httr::GET(paste0("https://api.sleeper.app/v1/league/", league_id, "/traded_picks")), as = "text"))
  # Check to see if returned object has length zero
  if(length(x) == 0) {
    # If length is zero, inform user but still return empty list
    message("No data found but still returning empty list. Was league ID entered correctly and are traded picks known to be there?")
    return(x)
  } else {
    # If length is not zero, return object (list)
    return(x)
  }
}
