% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{slga_product_info}
\alias{slga_product_info}
\title{SLGA Product Information}
\format{
A data frame with 23 observations and 14 variables \describe{
\item{Type}{Product Type - Soil or Landscape}
\item{Product}{Product Name}
\item{Short_Name}{Product short name}
\item{Code}{Product code}
\item{xmin}{left bounding longitude in decimal degrees}
\item{xmax}{right bounding longitude in decimal degrees}
\item{ymin}{bottom latitude in decimal degrees}
\item{ymax}{top bounding latitude in decimal degrees}
\item{offset_x}{Cell resolution in x dimension}
\item{offset_y}{Cell resolution in y dimension}
\item{origin_x}{x coordinate result of
  \code{\link[raster:origin]{raster::origin()}} for this dataset.}
\item{origin_y}{y coordinate result of
  \code{\link[raster:origin]{raster::origin()}} for this dataset.}
\item{ncol}{number of raster cells in x dimension}
\item{nrow}{number of raster cells in y dimension}
}
}
\source{
See also
\url{https://www.clw.csiro.au/aclep/soilandlandscapegrid/ProductDetails-SoilAttributes.html}
}
\usage{
slga_product_info
}
\description{
A data frame containing information about the products available from the
Soil and Landscape Grid of Australia.
}
\details{
All datasets are projected in EPSG:4326 (WGS84). Grid parameters have been
retrieved from metadata viewable with WCS DescribeCoverage requests.
}
\keyword{datasets}
