glubort <- function (..., .sep = "", .envir = parent.frame()) {
  abort(glue::glue(..., .sep = .sep, .envir = .envir))
}

collapse_and_trim <- function(x) {
  glue::glue_collapse(x, sep = ", ", width = 30L)
}

is_unbounded <- function(x) {
  is_infinite <- is.infinite(x)

  # Length checks are caught elsewhere
  if (length(is_infinite) != 1) {
    return(FALSE)
  }

  if (is_infinite) {
    x == Inf
  } else {
    FALSE
  }
}

check_all_size_one <- function(out) {
  if (vec_size(out) == 0L) {
    return(invisible(out))
  }

  size <- vec_size_common(!!!out)

  if (size != 1L) {
    sizes <- vapply(out, vec_size, integer(1))
    iteration <- which(sizes != 1L)[[1L]]
    bad_size <- sizes[[iteration]]
    stop_not_all_size_one(iteration, bad_size)
  }

  invisible(out)
}

check_is_list <- function(.l) {
  if (!is.list(.l)) {
    abort(paste0("`.l` must be a list, not ", vec_ptype_full(.l), "."))
  }

  invisible(.l)
}

stop_not_all_size_one <- function(iteration, size) {
  glubort("In iteration {iteration}, the result of `.f` had size {size}, not 1.")
}

# Thrown to here from C
stop_slide_start_past_stop <- function(starts, stops) {
  start_after_stop <- vec_compare(starts, stops) == 1L

  at <- which(start_after_stop)
  at <- collapse_and_trim(at)

  msg <- paste0(
    "In the ranges generated by `.before` and `.after`, ",
    "the start of the range is after the end of the range at location(s): {at}."
  )

  glubort(msg)
}

# Thrown to here from C
stop_hop_start_past_stop <- function(starts, stops) {
  start_after_stop <- vec_compare(starts, stops) == 1L

  at <- which(start_after_stop)
  at <- collapse_and_trim(at)

  msg <- paste0(
    "In the ranges generated by `.starts` and `.stops`, ",
    "a start is after a stop at location(s): {at}."
  )

  glubort(msg)
}

compute_size <- function(x, type) {
  SLIDE <- -1L
  PSLIDE_EMPTY <- 0L

  if (type == SLIDE) {
    vec_size(x)
  } else if (type == PSLIDE_EMPTY) {
    0L
  } else {
    vec_size(x[[1L]])
  }
}

# Ensures that `slide_vec(c(x = 1), ~.x, .ptype = NULL)` works, and keeps it
# in line with what `map_dbl(c(x = 1), ~c(y = 2))` does by only keeping names
# from `x`
vec_simplify <- function(x) {
  names <- vec_names(x)

  if (is.null(names)) {
    out <- vec_c(!!!x)
    return(out)
  }

  x <- vec_set_names(x, NULL)

  out <- vec_c(!!!x)

  vec_set_names(out, names)
}
