% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slide-index2.R, R/pslide-index.R
\name{slide_index2}
\alias{slide_index2}
\alias{slide_index2_vec}
\alias{slide_index2_dbl}
\alias{slide_index2_int}
\alias{slide_index2_lgl}
\alias{slide_index2_chr}
\alias{slide_index2_dfr}
\alias{slide_index2_dfc}
\alias{pslide_index}
\alias{pslide_index_vec}
\alias{pslide_index_dbl}
\alias{pslide_index_int}
\alias{pslide_index_lgl}
\alias{pslide_index_chr}
\alias{pslide_index_dfr}
\alias{pslide_index_dfc}
\title{Slide along multiples inputs simultaneously relative to an index}
\usage{
slide_index2(.x, .y, .i, .f, ..., .before = 0L, .after = 0L, .complete = FALSE)

slide_index2_vec(
  .x,
  .y,
  .i,
  .f,
  ...,
  .before = 0L,
  .after = 0L,
  .complete = FALSE,
  .ptype = NULL
)

slide_index2_dbl(
  .x,
  .y,
  .i,
  .f,
  ...,
  .before = 0L,
  .after = 0L,
  .complete = FALSE
)

slide_index2_int(
  .x,
  .y,
  .i,
  .f,
  ...,
  .before = 0L,
  .after = 0L,
  .complete = FALSE
)

slide_index2_lgl(
  .x,
  .y,
  .i,
  .f,
  ...,
  .before = 0L,
  .after = 0L,
  .complete = FALSE
)

slide_index2_chr(
  .x,
  .y,
  .i,
  .f,
  ...,
  .before = 0L,
  .after = 0L,
  .complete = FALSE
)

slide_index2_dfr(
  .x,
  .y,
  .i,
  .f,
  ...,
  .before = 0L,
  .after = 0L,
  .complete = FALSE,
  .names_to = rlang::zap(),
  .name_repair = c("unique", "universal", "check_unique")
)

slide_index2_dfc(
  .x,
  .y,
  .i,
  .f,
  ...,
  .before = 0L,
  .after = 0L,
  .complete = FALSE,
  .size = NULL,
  .name_repair = c("unique", "universal", "check_unique", "minimal")
)

pslide_index(.l, .i, .f, ..., .before = 0L, .after = 0L, .complete = FALSE)

pslide_index_vec(
  .l,
  .i,
  .f,
  ...,
  .before = 0L,
  .after = 0L,
  .complete = FALSE,
  .ptype = NULL
)

pslide_index_dbl(.l, .i, .f, ..., .before = 0L, .after = 0L, .complete = FALSE)

pslide_index_int(.l, .i, .f, ..., .before = 0L, .after = 0L, .complete = FALSE)

pslide_index_lgl(.l, .i, .f, ..., .before = 0L, .after = 0L, .complete = FALSE)

pslide_index_chr(.l, .i, .f, ..., .before = 0L, .after = 0L, .complete = FALSE)

pslide_index_dfr(
  .l,
  .i,
  .f,
  ...,
  .before = 0L,
  .after = 0L,
  .complete = FALSE,
  .names_to = rlang::zap(),
  .name_repair = c("unique", "universal", "check_unique")
)

pslide_index_dfc(
  .l,
  .i,
  .f,
  ...,
  .before = 0L,
  .after = 0L,
  .complete = FALSE,
  .size = NULL,
  .name_repair = c("unique", "universal", "check_unique", "minimal")
)
}
\arguments{
\item{.x, .y}{\verb{[vector]}

Vectors to iterate over. Vectors of size 1 will be recycled.}

\item{.i}{\verb{[vector]}

The index vector that determines the window sizes. The lower bound
of the window range will be computed as \code{.i - .before}, and the upper
bound as \code{.i + .after}. It is fairly common to supply a date vector
as the index, but not required.

There are 3 restrictions on the index:
\itemize{
\item The size of the index must match the size of \code{.x}, they will not be
recycled to their common size.
\item The index must be an \emph{increasing} vector, but duplicate values
are allowed.
\item The index cannot have missing values.
}}

\item{.f}{\verb{[function / formula]}

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function. There
are three ways to refer to the arguments:
\itemize{
\item For a single argument function, use \code{.}
\item For a two argument function, use \code{.x} and \code{.y}
\item For more arguments, use \code{..1}, \code{..2}, \code{..3} etc
}

This syntax allows you to create very compact anonymous functions.}

\item{...}{Additional arguments passed on to the mapped function.}

\item{.before, .after}{\verb{[vector(1) / Inf]}

The number of values before or after the current element of \code{.i} to
include in the sliding window. Set to \code{Inf} to select all elements
before or after the current element. Negative values are allowed, which
allows you to "look forward" from the current element if used as the
\code{.before} value, or "look backwards" if used as \code{.after}.

Any object that can be added or subtracted from \code{.i} with \code{+} and \code{-}
can be used. For example, a lubridate period, such as \code{\link[lubridate:weeks]{lubridate::weeks()}}.

The ranges that result from computing \code{.i - .before} and \code{.i + .after}
have the same 3 restrictions as \code{.i} itself.}

\item{.complete}{\verb{[logical(1)]}

Should \code{.f} be evaluated on complete windows only? If \code{FALSE},
the default, then partial computations will be allowed.}

\item{.ptype}{\verb{[vector(0) / NULL]}

A prototype corresponding to the type of the output.

If \code{NULL}, the default, the output type is determined by computing the
common type across the results of the calls to \code{.f}.

If supplied, the result of each call to \code{.f} will be cast to that type,
and the final output will have that type.

If \code{getOption("vctrs.no_guessing")} is \code{TRUE}, the \code{.ptype} must be
supplied. This is a way to make production code demand fixed types.}

\item{.names_to}{\itemize{
\item By default, input names are \link[rlang:zap]{zapped}.
\itemize{
\item If a string, specifies a column where the input names will be
copied. These names are often useful to identify rows with
their original input. If a column name is supplied and \code{...} is
not named, an integer column is used instead.
\item If \code{NULL}, the input names are used as row names.
}
}}

\item{.name_repair}{One of \code{"unique"}, \code{"universal"}, or
\code{"check_unique"}. See \code{\link[vctrs:vec_as_names]{vec_as_names()}} for the meaning of these
options.

With \code{vec_rbind()}, the repair function is applied to all inputs
separately. This is because \code{vec_rbind()} needs to align their
columns before binding the rows, and thus needs all inputs to
have unique names. On the other hand, \code{vec_cbind()} applies the
repair function after all inputs have been concatenated together
in a final data frame. Hence \code{vec_cbind()} allows the more
permissive minimal names repair.}

\item{.size}{If, \code{NULL}, the default, will determine the number of
rows in \code{vec_cbind()} output by using the standard recycling rules.

Alternatively, specify the desired number of rows, and any inputs
of length 1 will be recycled appropriately.}

\item{.l}{\verb{[list]}

A list of vectors. The length of \code{.l} determines the
number of arguments that \code{.f} will be called with. If \code{.l} has names,
they will be used as named arguments to \code{.f}. Elements of \code{.l} with size
1 will be recycled.}
}
\value{
A vector fulfilling the following invariants:

\subsection{\code{slide_index2()}}{
\itemize{
\item \code{vec_size(slide_index2(.x, .y)) == vec_size_common(.x, .y)}
\item \code{vec_ptype(slide_index2(.x, .y)) == list()}
}

}

\subsection{\code{slide_index2_vec()} and \verb{slide_index2_*()} variants}{
\itemize{
\item \code{vec_size(slide_index2_vec(.x, .y)) == vec_size_common(.x, .y)}
\item \code{vec_size(slide_index2_vec(.x, .y)[[1]]) == 1L}
\item \code{vec_ptype(slide_index2_vec(.x, .y, .ptype = ptype)) == ptype}
}

}

\subsection{\code{pslide_index()}}{
\itemize{
\item \code{vec_size(pslide_index(.l)) == vec_size_common(!!! .l)}
\item \code{vec_ptype(pslide_index(.l)) == list()}
}

}

\subsection{\code{pslide_index_vec()} and \verb{pslide_index_*()} variants}{
\itemize{
\item \code{vec_size(pslide_index_vec(.l)) == vec_size_common(!!! .l)}
\item \code{vec_size(pslide_index_vec(.l)[[1]]) == 1L}
\item \code{vec_ptype(pslide_index_vec(.l, .ptype = ptype)) == ptype}
}

}
}
\description{
\code{slide_index2()} and \code{pslide_index()} represent the combination
of \code{\link[=slide2]{slide2()}} and \code{\link[=pslide]{pslide()}} with \code{\link[=slide_index]{slide_index()}}, allowing you to iterate
over multiple vectors at once relative to an \code{.i}-ndex.
}
\examples{
# Notice that `i` is an irregular index!
x <- 1:5
y <- 6:10
i <- as.Date("2019-08-15") + c(0:1, 4, 6, 7)

# When we slide over `i` looking back 1 day, the irregularity is respected.
# When there is a gap in dates, only 2 values are returned (one from
# `x` and one from `y`), otherwise, 4 values are returned.
slide_index2(x, y, i, ~c(.x, .y), .before = 1)

}
\seealso{
\code{\link[=slide2]{slide2()}}, \code{\link[=hop_index2]{hop_index2()}}, \code{\link[=slide_index]{slide_index()}}
}
