%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:17:34.
% Do NOT modify this file, instead modify the source (sma/R/Rinit.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


\name{init.data}

\alias{init.data}

\title{Creating a Data Structure for Multi-slide Microarray Experiments}

\description{
Interactive function which creates a data structure for multi-slide
microarray experiments.  The data structure is a list of
matrices. For each spotted DNA sequence, the list stores raw red and
green signal intensities as well as red and green background
intensities. The function also allows the user to add data to an
existing structure. 
}

\usage{
init.data()
}

\arguments{
None.
}

\value{
  List containing the following components:
  \item{R}{contains the raw red intensities, R.}
  \item{G}{contains the raw green intensities, G.}
  \item{Rb}{contains the background red intensities, Rb.}
  \item{Gb}{contains the background green intensities, Gb.}
}

\author{
  Yee Hwa Yang, \email{yeehwa@stat.berkeley.edu} \cr
  Sandrine Dudoit, \email{sandrine@stat.berkeley.edu}
}

\examples{
## mouse.data <- init.data()

## Here is what you should see:
## Are you creating a new data matrix or adding new array data
## to a prexisting data matrix? 
## Enter "n" for creating and "a" for adding new array data: n
## Do the names of all your datasets have the following format: 
## prefix1, prefix2, prefix3?, ... Here prefix can be any name, 
## but the suffixes must be integers 1,2, ..., # of arrays. 
## Enter "y" for yes, "n" for no: y
## Enter the prefix:mouse
## Enter the number of arrays to be processed:6
## Enter the name of Cy3 raw data: Gmean
## Enter the name of Cy3 background: morphG
## Enter the name of Cy5 raw data: Rmean
## Enter the name of Cy5 background: morphR
## Finished creating new dataset.
}

\keyword{attribute}
%\keyword{microarray.}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
