%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:17:46.
% Do NOT modify this file, instead modify the source (sma/R/Rdisc.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{plot.cor}

\alias{plot.cor}

\title{Red and Green Color Image of Correlation Matrix}

\description{
This function produces a red and green color image of a correlation
matrix using an RGB color specification. Increasingly positive
correlations are represented with reds of increasing intensity, and
increasingly negative correlations are represented with greens of
increasing intensity.  
}

\usage{
plot.cor(X, new=F, nrgcols=50, labels=F, labcols=1, title="", ...)
}

\arguments{
 \item{X}{a matrix of numerical values.}
 \item{new}{If \code{new=F}, \code{X} must already be a correlation
 matrix. If \code{new=T}, the correlation matrix for the columns of
 \code{X} is computed and displayed in the image.} 
 \item{nrgcols}{the number of colors (>= 1) to be used in the red
 and green palette.} 
 \item{labels}{vector of character strings to be placed at the
 tickpoints, labels for the columns of \code{X}.} 
 \item{labcols}{colors to be used for the labels of the columns of
 \code{X}. \code{labcols} can have either length 1, in which case
 all the labels are displayed using the same color, or the same
 length as \code{labels}, in which case a color is specified for the
 label of each column of \code{X}.} 
 \item{title}{character string, overall title for the plot.}
 \item{\dots}{graphical parameters may also be supplied as arguments to
          the function (see \code{\link{par}}). For comparison purposes, 
 it is good to set \code{zlim=c(-1,1)}.}
}
}


\author{
  Sandrine Dudoit, \email{sandrine@stat.berkeley.edu}
}

\seealso{\code{\link{plot.mat}},\code{\link{rgcolors.func}},
\code{\link{cor.na}}, \code{\link{cor}}, \code{\link{image}},
\code{\link{rgb}}.} 


%\keyword{Microarray, correlation matrix, image.}

\keyword{hplot}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
