% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcmds.R
\name{bcmds}
\alias{bcmds}
\alias{bcStressMin}
\alias{bcstressMin}
\alias{boxcoxmds}
\title{Box-Cox MDS}
\usage{
bcmds(
  delta,
  mu = 1,
  lambda = 1,
  rho = 0,
  ndim = 2,
  itmax = 2000,
  init = NULL,
  verbose = 0,
  addD0 = 1e-04,
  principal = FALSE
)

bcStressMin(
  delta,
  mu = 1,
  lambda = 1,
  rho = 0,
  ndim = 2,
  itmax = 2000,
  init = NULL,
  verbose = 0,
  addD0 = 1e-04,
  principal = FALSE
)

bcstressMin(
  delta,
  mu = 1,
  lambda = 1,
  rho = 0,
  ndim = 2,
  itmax = 2000,
  init = NULL,
  verbose = 0,
  addD0 = 1e-04,
  principal = FALSE
)

boxcoxmds(
  delta,
  mu = 1,
  lambda = 1,
  rho = 0,
  ndim = 2,
  itmax = 2000,
  init = NULL,
  verbose = 0,
  addD0 = 1e-04,
  principal = FALSE
)
}
\arguments{
\item{delta}{dissimilarity or distance matrix, dissimilarity or distance data frame or 'dist' object}

\item{mu}{mu parameter. Should be 0 or larger for everything working ok. If mu<0 it works but I find the MDS model is strange and normalized stress tends towards 0 regardless of fit. Use normalized stress at your own risk in that case.}

\item{lambda}{lambda parameter. Must be larger than 0.}

\item{rho}{the rho parameter, power for the weights (the easiest).}

\item{ndim}{the dimension of the configuration}

\item{itmax}{number of optimizing iterations, defaults to 2000.}

\item{init}{initial configuration. If NULL a classical scaling solution is used.}

\item{verbose}{prints progress if > 3.}

\item{addD0}{a small number that's added for D(X)=0 for numerical evaluation of worst fit (numerical reasons, see details). If addD0=0 the normalized stress for mu!=0 and mu+lambda!=0 is correct, but will give useless normalized stress for mu=0 or mu+lambda!=0.}

\item{principal}{If 'TRUE', principal axis transformation is applied to the final configuration}
}
\value{
an object of class 'bcmds' (also inherits from 'smacofP'). It is a list with the components
\itemize{
\item delta: Observed, untransformed dissimilarities
\item tdelta: Observed explicitly transformed dissimilarities, normalized
\item dhat: Explicitly transformed dissimilarities (dhats)
\item confdist: Configuration dissimilarities
\item conf: Matrix of fitted configuration
\item stress: Default stress  (stress 1; sqrt of explicitly normalized stress)
\item ndim: Number of dimensions
\item model: Name of MDS model
\item type: Must be "ratio" here. 
\item niter: Number of iterations
\item nobj: Number of objects
\item pars: hyperparameter vector theta
\item weightmat:  delta^rho
\item parameters, pars, theta: The parameters supplied
\item call the call
}
and some additional components
\itemize{
\item stress.m: default stress is the explicitly normalized stress on the normalized, transformed dissimilarities
\item mu: mu parameter (for attraction)
\item lambda: lambda parameter (for repulsion)
\item rho: rho parameter (for weights) 
}
}
\description{
This function minimizes the Box-Cox Stress of Chen & Buja (2013) via gradient descent. This is a ratio metric scaling method. The transformations are not straightforward to interpret but mu is associated with fitted distances in the configuration and lambda with the dissimilarities. Concretely for fitted distances (attraction part) it is BC_{mu+lambda}(d(X)) and for the repulsion part it is delta^lambdaBC_{mu}(d(X)) with BC being the one-parameter Box Cox transformation.
}
\details{
For numerical reasons with certain parameter combinations, the normalized stress uses a configuration as worst result where every d(X) is 0+addD0. The same number is not added to the delta so there is a small inaccuracy of the normalized stress (but negligible if min(delta)>>addD0). Also, for mu<0 or mu+lambda<0 the normalization cannot generally be trusted (in the worst case of D(X)=0 one would have an 0^(-a)).
}
\examples{
dis<-smacof::kinshipdelta
res<-bcmds(dis,mu=2,lambda=1.5,rho=0)
res
summary(res)
plot(res)

}
\author{
Lisha Chen & Thomas Rusch
}
