% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multistart.R
\name{multistart}
\alias{multistart}
\title{Multistart MDS function}
\usage{
multistart(
  object,
  mdscall = NULL,
  ndim = 2,
  conflist,
  nstarts = 10,
  return.all = FALSE,
  verbose = TRUE,
  min = -5,
  max = 5
)
}
\arguments{
\item{object}{A fitted object of class 'smacofP', 'smacofB' or 'smacof'. If supplied this takes precedence over the call argument. If given this is added to the output and may be the optimal one.}

\item{mdscall}{Alternatively to a fitted object, one can pass a syntactically valid call for any of the MDS functions cops, stops or smacof that find a configuration (not the ones that do parameter selection like pcops or stops). If object and call is given, object takes precedence.}

\item{ndim}{Dimensions of target space.}

\item{conflist}{Optional list of starting configurations.}

\item{nstarts}{If conflist is not supplied, how many random starting configurations should be used.}

\item{return.all}{Should all fitted MDS be returned. If FALSE (default) only the optimal one is returned.}

\item{verbose}{If >0 prints the fitting progress.}

\item{min}{lower bound for the uniform distribution to sample from}

\item{max}{upper bound for the uniform distribution to sample from}
}
\value{
if 'return.all=FALSE', a list with the best fitted model as '$best' (minimal badness-of-fit of all fitted models) and '$stressvec' the stresses of all models. If 'return.all=TRUE' a list with slots
\itemize{
\item best: The object resulting from the fit that had the overall lowest objective function value (usually stress)
\item stressvec: The vector of objective function values
\item models: A list of all the fitted objects.
}
}
\description{
For different starting configurations, this function fits a series of PS models given in object or call and returns the one with the lowest stress overall. The starting configuirations can be supplied or are generated internally.
}
\details{
If no configuration list is supplied, then nstarts configurations are simulated. They are drawn from a ndim-dimesnional uniform distribution with minimum min and maximum max. We recommend to use the route via supplying a fitted model as these are typically starting from a Torgerson configuration and are likely quite good.    

One can simply extract $best and save that and work with it right away.
}
\examples{
dis<-smacof::kinshipdelta

## Version 1: Using a fitted object (recommended)
res1<-rStressMin(delta=dis,type="ordinal",itmax=100)
resm<-multistart(res1,nstarts=2)
## best model
res2<-resm$best
#it's starting configuration
res2$init

## Version 2: Using a call object and supplying conflist
conflist<-list(res2$init,jitter(res2$init,1))
c1 <- call("rstressMin",delta=dis,type="ordinal",itmax=100)
resm<-multistart(mdscall=c1,conflist=conflist,return.all=TRUE)

}
