% Generated by roxygen2 (4.0.2): do not edit by hand
\name{lines.confenvkd}
\alias{lines.confenvkd}
\title{Adds lines to plot of \code{fv} object.}
\usage{
\method{lines}{confenvkd}(x, ...)
}
\arguments{
\item{x}{A \code{cienv} object from the \code{confint.kdenv} function.}

\item{...}{Further graphical arguments for lines function.}
}
\value{
A line is added to the plot on the current graphics device. No values are returned.
}
\description{
\code{lines} plots the confidence envelopes on a plot of the results of the \code{kdest} or \code{kdenv} objects.
}
\examples{
data(grave)
kd = kdest(grave, nsim = 9)
ci = confenv(kd, level = 0.9)
plot(kd, legend = FALSE, main = "")
lines(ci, lty = 2)
legend("topleft", legend = c("observed", "average", "max/min", "90\% conf. bands"),
lty = c(1, 2, 1, 3), col = c("black", "red", "grey", "black"))
}
\author{
Joshua French
}

