% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmme.R
\name{rBMME}
\alias{rBMME}
\alias{rBmme}
\title{Sampling from Brown Motion with Measurement Error}
\usage{
rBMME(time, dim = 2, sigma = 1, delta = 1)

rBmme(time, dim = 2, sigma = 1, delta = 1)
}
\arguments{
\item{time}{vector of time points at which observations are to be sampled}

\item{dim}{(integer) dimension of the Brownian motion}

\item{sigma}{volatility parameter (sd) of the Brownian motion}

\item{delta}{sd parameter of measurement error}
}
\value{
A \code{data.frame} whose first column is the time points and whose
  other columns are coordinates of the locations.
}
\description{
Given the volatility parameters of a Brownian motion and normally
distributed measurement errors, generate the process at discretely
observed time points of a given dimension.
}
\examples{
tgrid <- seq(0, 10, length = 1001)
## make it irregularly spaced
tgrid <- sort(sample(tgrid, 800))
dat <- rBMME(tgrid, 1, 1)
plot(dat[,1], dat[,2], xlab="t", ylab="X(t)", type="l")

}
\references{
Pozdnyakov V., Meyer, TH., Wang, Y., and Yan, J. (2013)
On modeling animal movements using Brownian motion with measurement
error. Ecology 95(2): p247--253. doi:doi:10.1890/13-0532.1.
}
