% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smart_class.R
\docType{class}
\name{SmartProject}
\alias{SmartProject}
\title{SmartProject Class}
\format{\code{\link{R6Class}} object.}
\value{
Object of \code{\link{R6Class}} with attributes and methods to fullfill
a complete analisys with the SMART approach.
}
\description{
The \code{SmartProject} class implements the main class of
\pkg{smartR} package.
}
\section{Fields}{

\describe{
\item{\code{rawDataSurvey}}{Stores the raw survey data after being populated by \code{loadSurveyLFD()} method.}

\item{\code{yearInSurvey}}{Stores the distinct years in the \code{rawDataSurvey} time-serie.}

\item{\code{specieInSurvey}}{Stores the distinct species in the \code{rawDataSurvey} time-serie.}

\item{\code{surveyBySpecie}}{Stores a list of \code{\link{SurveyBySpecie}} objects, one for each species in the time-series.}

\item{\code{rawDataFishery}}{Stores the raw fishery data as is in the provided csv file. The attribute is populated by \code{loadFisheryLFD()} method.}

\item{\code{yearInFishery}}{Stores the distinct years in the \code{rawDataFishery} time-serie.}

\item{\code{specieInFishery}}{Stores the distinct species in the \code{rawDataFishery} time-serie.}

\item{\code{fisheryBySpecie}}{Stores a list of \code{\link{FisheryBySpecie}} objects, one for each species in the time-series.}

\item{\code{gooLstCoho}}{Stores a list of plots of species cohorts spatial distribution .}

\item{\code{sampMap}}{Stores the \code{\link[=SampleMap]{environment}} object.}

\item{\code{fleet}}{Stores the \code{\link{FishFleet}} object.}

\item{\code{simProd}}{Stores the simulated pattern of production.}

\item{\code{simEffo}}{Stores the simulated pattern of effort.}

\item{\code{simBanFG}}{Stores a vector of fishable/banned fishing grounds.}

\item{\code{simSpatialCost}}{Stores the simulated pattern of spatial costs.}

\item{\code{simEffortCost}}{Stores the simulated pattern of effort costs.}

\item{\code{simProdCost}}{Stores the simulated pattern of production costs.}

\item{\code{simTotalCost}}{Stores the simulated pattern of total costs.}

\item{\code{simRevenue}}{Stores the simulated pattern of revenue by species and fishing ground.}

\item{\code{simTotalRevenue}}{Stores the simulated pattern of total revenues.}

\item{\code{simCostRevenue}}{Stores the simulated pattern of costs and revenues.}

\item{\code{simResPlot}}{Stores the plots with the simulation' results.}

\item{\code{outGmat}}{Stores the evolution of gains during the simulation.}

\item{\code{outOptimEffo}}{Stores the resulting pattern of effort.}

\item{\code{outWeiProp}}{Stores the annual proportion of fish by cohort and fishing ground.}

\item{\code{outWeiPropQ}}{Stores the seasonal proportion of fish by cohort and fishing ground.}
}}

\section{Methods}{

\describe{
  \item{\code{setCostInput()}}{This method is used to setup the required data for costs computation}
  \item{\code{setInProduction()}}{This method is used to setup the required data for production costs computation}
  \item{\code{setDaysAtSea()}}{This method is used to compute the number of Days at Sea of each vessel}
  \item{\code{setEffortIndex()}}{This method is used to compute the value of the Effort Index}
  \item{\code{setProductionIndex()}}{This method is used to compute the value of the Production Index}
  \item{\code{getHarbFgDist()}}{This method is used to compute the weighted average distance of every fishing ground to each harbour}
  \item{\code{setFgWeigDist()}}{This method is used as helper function to get the weighted average distance between fishing ground and harbours}
  \item{\code{setRegHarbBox()}}{This method is used to compute the distance of each harbour to every fishing ground centroid}
  \item{\code{loadSurveyLFD(csv_path)}}{This method is used to load the raw survey LFD data from a  csv file}
  \item{\code{loadFisheryLFD(csv_path)}}{This method is used to load the raw fishery LFD data from a  csv file}
  \item{\code{setYearSurvey()}}{This method is used to store the distinct year in the survey time-series}
  \item{\code{setYearFishery()}}{TThis method is used to store the distinct year in the fishery time-series}
  \item{\code{loadMap(map_path)}}{This method is used to load the Environmental Grid and initialize the Environment object}
  \item{\code{createFleet()}}{This method is used to initialize the Fleet object}
  \item{\code{setSpecieSurvey()}}{This method is used to store the distinct species in the survey dataset}
  \item{\code{setSpecieFishery()}}{This method is used to store the distinct species in the fishery dataset}
  \item{\code{splitSpecieSurvey()}}{This method is used to split the survey dataset by species}
  \item{\code{splitSpecieFishery()}}{This method is used to split the fishery dataset by species}
  \item{\code{addSpecieSurvey(sing_spe)}}{This method is used to initialize a new \code{surveyBySpecie} object}
  \item{\code{addSpecieFishery(sing_spe)}}{This method is used to initialize a new \code{fisheryBySpecie} object}
  \item{\code{setSpreaFishery()}}{This method is used to prepare the fishery LFD data for MCMC analysis}
  \item{\code{setSpatFishery()}}{This method is used to setup the plot with the spatial distribution of the fishery dataset}
  \item{\code{setSpreaSurvey()}}{This method is used to prepare the survey LFD data for MCMC analysis}
  \item{\code{setSpatSurvey()}}{This method is used to setup the plot with the spatial distribution of the survey dataset}
  \item{\code{setDepthSurvey()}}{This method is used to assign the depth of each survey tow}
  \item{\code{setStratumSurvey()}}{This method is used to assign a depth stratum to each survey tow}
  \item{\code{setAbuAvgAll()}}{This method is used to compute the spiecies abundances at each survey stratum}
  \item{\code{setMeditsIndex()}}{This method is used to compute the MEDITS index}
  \item{\code{setStrataAbu()}}{This method is used to compute the weighted number of individuals of each size in every stratum}
  \item{\code{loadFleeEffoDbs(effort_path, met_nam, onBox = TRUE, perOnBox = 1)}}{This method is used to extract the vms data from one or more vmsbase DB}
  \item{\code{ggplotRawPoints(year)}}{This method is used to plot the raw vms points}
  \item{\code{ggplotFgWeigDists()}}{This method is used to plot the weighted average distance between harbours and fishing grounds}
  \item{\code{setAvailData()}}{This method is used to gather the required data for the spatial clustering}
  \item{\code{predictProduction(specie)}}{This method is used to compute the estimated production}
  \item{\code{simProdAll(selRow = numeric(0))}}{This method is used to compute the simulated production}
  \item{\code{genSimEffo(method = "flat", selRow = numeric(0), areaBan = numeric(0))}}{This method is used to create a simulated pattern of effort}
  \item{\code{getSimSpatialCost()}}{This method is used to compute the simulated spatial costs}
  \item{\code{getSimEffortCost()}}{This method is used to compute the simulated effort costs}
  \item{\code{getSimProdCost()}}{This method is used to compute the simulated production costs}
  \item{\code{getSimTotalCost()}}{This method is used to collect all the simulated costs}
  \item{\code{getSimRevenue(selRow = numeric(0), timeScale = "Year")}}{This method is used to compute the simulated revenues}
  \item{\code{getLWstat()}}{This method is used to compute the length/weight statistics for each fishing ground}
  \item{\code{simulateFishery(thr0 = 100, effoBan = numeric(0), timeStep = "Year")}}{This method is used to simulate one year of fishing}
  \item{\code{setSimResults()}}{This method is used to store the results of a simulation run}
  \item{\code{ggplotFishingPoints(year)}}{This method is used to plot the fishing points}
  \item{\code{setCellPoin()}}{This method is used assign a cell to each vms point}
  \item{\code{setTrackHarb()}}{This method is used to assign the harbour to each fishing trip}
  \item{\code{setFishGround(numCut)}}{This method is used to setup the fishing ground configuration}
  \item{\code{addFg2Fishery()}}{This method is used to add the fishing ground information to each fishery data point}
  \item{\code{addFg2Survey()}}{This method is used to add the fishing ground information to each survey data point}
  \item{\code{setWeekEffoMatrCell()}}{This method is used to combine the raw effort points in weekly aggregated effort by cell}
  \item{\code{setWeekEffoMatrGround()}}{This method is used to combine the raw effort points in weekly aggregated effort by fishing ground}
  \item{\code{ggplotGridEffort(year)}}{This method is used to plot the gridded fishing effort}
  \item{\code{getNnlsModel(specie, minobs, thr_r2)}}{This method is used to compute the coefficients of the NNLS model}
  \item{\code{cohoDisPlot(whoSpe, whoCoh, whiYea, interp)}}{This method is used to store the spatial distribution of the species by cohort}
  }
}

\examples{
# Initialize SmartProject
yourSmartRstudy <- SmartProject$new()

# Initialize fleet object
yourSmartRstudy$createFleet()


######################
## Environment Data ##
######################

# Locate the example environment asset' file
envAssetPath <- system.file("extdata/mapAsset.RDS", package = "smartR")

# Load environment asset' data
yourSmartRstudy$importEnv(readRDS(envAssetPath))

# Setup case study' map
yourSmartRstudy$sampMap$getGooMap()
yourSmartRstudy$sampMap$setGooGrid()
yourSmartRstudy$sampMap$setGooBbox()
yourSmartRstudy$sampMap$setGgDepth()
yourSmartRstudy$sampMap$setGgBioDF()
# View case study' grid
print(yourSmartRstudy$sampMap$gooGrid)


################
## Fleet Data ##
################

# Locate the example fleet asset' file
effAssetPath <- system.file("extdata/effAsset.RDS", package = "smartR")

# Load fleet asset' data
yourSmartRstudy$fleet$rawEffort <- readRDS(effAssetPath)

# Setup fishing vessel ids
yourSmartRstudy$fleet$setEffortIds()

# View speed distribution to setup fishing point filter
yourSmartRstudy$fleet$plotSpeedDepth(
which_year = "2012",
speed_range = c(2, 8),
depth_range = c(-20, -600)
)

# Setup fishing points' filter
yourSmartRstudy$fleet$setFishPoinPara(
speed_range = c(2, 8),
depth_range = c(-20, -600)
)

# Compute fishing points
yourSmartRstudy$fleet$setFishPoin()

# Assign cell id to each fishing point
yourSmartRstudy$setCellPoin()

# Add week and month number to each point
yourSmartRstudy$fleet$setWeekMonthNum()


#####################
## Fishing Grounds ##
#####################

# Setup available data to identify fishing areas
yourSmartRstudy$setAvailData()

# Setup cluster analysis input
yourSmartRstudy$sampMap$setClusInpu()

# Run cluster analysis with the SKATER method
yourSmartRstudy$sampMap$calcFishGrou(numCuts = 3, minsize = 10,
 modeska = "S", skater_method = "manhattan", nei_queen = FALSE)

# Setup cluster plot with 3 clusters
yourSmartRstudy$sampMap$setCutResult(ind_clu = 3)

# Map of the clusters' configuration
print(yourSmartRstudy$sampMap$ggCutFGmap)

}
\keyword{data}
