% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute-power.R
\name{computePower}
\alias{computePower}
\title{Compute the Power in a SMART}
\usage{
computePower(V, Delta, min_Delta, alpha = 0.05, sample_size)
}
\arguments{
\item{V}{The covariance matrix of mean EDTR estimators.}

\item{Delta}{The vector of effect sizes with a zero indicating the best EDTR.}

\item{min_Delta}{The minimum desired detectable effect size.}

\item{alpha}{The Type I error rate for not including the true best EDTR.}

\item{sample_size}{The sample size.}
}
\value{
The power to exclude from the set of best EDTR all EDTR
which are inferior to the best EDTR by min_Delta or more.
}
\description{
Computes the power in an arbitrary SMART design with
the goal of identifying optimal embedded dynamic treatment regime (EDTR).
The power is the probability of excluding from the set of best EDTRs
all EDTRs which are inferior to the best EDTR by min_Delta or more.
}
\details{
The true best EDTR is included
in the set of best with probability at least 1-alpha.
Multiple comparisons are adjusted for using the
Multiple Comparison with the Best methodology.
}
\examples{

  \donttest{
  V <- rbind(c(1, 0.3, 0.3, 0.3),
             c(0.3, 1, 0.3, 0.3),
             c(0.3, 0.3, 1, 0.3),
             c(0.3, 0.3, 0.3, 1))

  #Compute power to exclude EDTRs inferior to the best by 0.3 or more
  #The first DTR is best and the other three are inferior by 0.2, 0.6, and 0.3
  #The best DTR is included with probability greater than or equal to 95\%.
  computePower(V,
               Delta = c(0, 0.2, 0.6, 0.3),
               min_Delta = 0.3,
               sample_size = 200)
  }
}
\seealso{
\code{\link{computeSampleSize}}
}
