% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morancr.test.R
\name{morancr.test}
\alias{morancr.test}
\title{Constant-risk Moran's I-based test}
\usage{
morancr.test(
  cases,
  pop,
  w,
  ex = sum(cases)/sum(pop) * pop,
  nsim = 499,
  alternative = "greater"
)
}
\arguments{
\item{cases}{The number of cases observed in each region.}

\item{pop}{The population size associated with each
region.}

\item{w}{A binary spatial adjacency matrix for the
regions.}

\item{ex}{The expected number of cases for each region.
The default is calculated under the constant risk
hypothesis.}

\item{nsim}{The number of simulations from which to
compute the p-value.}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of "greater" (default), "two.sided", or "less". You can specify
just the initial letter.}
}
\value{
Returns a \code{smerc_similarity_test}.
}
\description{
\code{morancr.test} performs a test of clustering using the constant-risk
version of the Moran's I statistic proposed by Walter (1992) under the
constant risk hypothesis.
}
\examples{
data(nydf)
data(nyw)
morancr.test(cases = nydf$cases, pop = nydf$pop, w = nyw, nsim = 9)
}
\references{
Walter, S. D. (1992). The analysis of regional patterns in health
  data: I. Distributional considerations. American Journal of Epidemiology,
  136(6), 730-741.
}
\seealso{
\code{\link{morancr.stat}}
}
\author{
Joshua French
}
