% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.sem.R
\name{plot.sem}
\alias{plot.sem}
\title{Plot Diagnostics for sem Objects}
\usage{
\method{plot}{sem}(x, ...)
}
\arguments{
\item{x}{an object of type "sem", typical result of \code{\link{semLm}} or
\code{\link{semLme}}.}

\item{...}{optional arguments passed to generic function.}
}
\value{
Convergence and density plots.
}
\description{
Available are convergence plots for the estimated
fixed effects model parameters and the residual variance of
the linear or mixed linear regression model. If the Box-Cox transformation
is used
for the transformation of the dependent variable, a convergence plot
of the transformation parameter lambda is also available.
In each of the convergence plots, the estimated parameter is plotted against
the iteration step of the SEM-algorithm.
A vertical line indicates the end of the burn-in period. Furthermore, the
estimated density of the simulated dependent variable of the last iteration
step
is plotted with a histogram of the interval censored true dependent variable
in the back.
}
\references{
Walter, P., Gross, M., Schmid, T. and Tzavidis, N. (2017). Estimation of
Linear and Non-Linear Indicators
using Interval Censored Income Data. School of Business & Economics,
Discussion
Paper.
}
\seealso{
\code{\link{semObject}}, \code{\link{semLm}}, \code{\link{semLme}}
}
