% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/miscUtils.R
\name{array_Grid}
\alias{array_Grid}
\title{Reshape or coerce an array of responses}
\usage{
array_Grid(X, Y, dropCol = TRUE)
}
\arguments{
\item{X}{An object with class \code{"GriData"} or that can be
coerced to this class.}

\item{Y}{A vector of length \code{n} or a matrix with \code{n}
rows where \code{n} is the number of nodes in \code{X}. In the
first case, \code{Y} is coerced into a matrix with one column.}

\item{dropCol}{Logical. When \code{Y} is a vector and \code{dropCol}
is \code{TRUE}, the dimension of the array is \code{nlevels(X)}, else
it is \code{c(nlevels(X), 1)}.}
}
\value{
An array with dimension \code{c(nlevels(X), ncol(Y))} or
\code{nlevels(X)} containing the elements of \code{Y} in
correspondence with the levels of \code{X}.
}
\description{
Reshape or coerce an array of responses.
}
\examples{
myGD <- Grid(nlevels = c(20, 25))
F <- apply_Grid(myGD, branin)
aF <- array_Grid(X = myGD, Y = F)
}
\seealso{
\code{\link{apply_Grid}} to compute a vector of response for
a given function.
}

