% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smmR-package.R
\docType{package}
\name{smmR-package}
\alias{smmR}
\alias{smmR-package}
\title{smmR : Semi-Markov Models, Markov Models and Reliability}
\description{
This package performs parametric and non-parametric estimation
and simulation for multi-state discrete-time semi-Markov processes. For the
parametric estimation, several discrete distributions are considered for the
sojourn times: Uniform, Geometric, Poisson, Discrete Weibull and Negative
Binomial. The non-parametric estimation concerns the sojourn time
distributions, where no assumptions are done on the shape of distributions.
Moreover, the estimation can be done on the basis of one or several sample
paths, with or without censoring at the beginning or/and at the end of the
sample paths. Estimation and simulation of discrete-time k-th order Markov
chains are also considered.

Semi-Markov models are specified by using the functions \code{smmparametric()}
and \code{smmnonparametric()} for parametric and non-parametric specifications
respectively. These functions return objects of S3 class (\code{smm},
\code{smmparametric}) and (\code{smm}, \code{smmnonparametric}) respectively (\code{smm} class
inherits from S3 classes \code{smmparametric} or \code{smmnonparametric}). Thus, \code{smm}
is like a wrapper class for semi-Markov model specifications.

Based on a model specification (an object of class \code{smm}), it is possible to:
\itemize{
\item \strong{simulate} one or several sequences with the method
\code{simulate.smm()};
\item \strong{plot} conditional sojourn time distributions (method
\code{plot.smm()});
\item compute \strong{log-likelihood}, \strong{AIC} and \strong{BIC} criteria (methods
\code{loglik()}, \code{aic()}, \code{bic()});
\item compute \strong{reliability}, \strong{maintainability}, \strong{availability},
\strong{failure rates} (methods \code{reliability()}, \code{maintainability()},
\code{availability()}, \code{failureRate()}).
}

Estimations of parametric and non-parametric semi-Markov models can be done
by using the function \code{fitsmm()}. This function returns an
object of S3 class \code{smmfit}. The class \code{smmfit} inherits from classes
(\code{smm}, \code{smmparametric}) or (\code{smm}, \code{smmnonparametric}).

Based on a fitted/estimated semi-Markov model (an object of class \code{smmfit}),
it is possible to:
\itemize{
\item \strong{simulate} one or several sequences with the method
\code{simulate.smmfit()};
\item \strong{plot} estimated conditional sojourn time distributions
(method \code{plot.smmfit()});
\item compute \strong{log-likelihood}, \strong{AIC} and \strong{BIC} criteria (methods
\code{loglik()}, \code{aic()}, \code{bic()});
\item compute estimated \strong{reliability}, \strong{maintainability},
\strong{availability}, \strong{failure rates} and their \strong{confidence intervals}
(methods \code{reliability()}, \code{maintainability()}, \code{availability()},
\code{failureRate()}).
}
}
\references{
V. S. Barbu, N. Limnios. (2008). Semi-Markov Chains and Hidden Semi-Markov
Models Toward Applications - Their Use in Reliability and DNA Analysis.
New York: Lecture Notes in Statistics, vol. 191, Springer.

R.E. Barlow, A.W. Marshall, and F. Prochan. (1963). Properties of probability
distributions with monotone hazard rate. Ann. Math. Statist., 34, 375-389.

T. Nakagawa and S. Osaki. (1975). The discrete Weibull distribution.
IEEE Trans. Reliabil., R-24, 300-301.

D. Roy and R. Gupta. (1992). Classification of discrete lives.
Microelectron. Reliabil., 32 (10), 1459-1473.

I. Votsi & A. Brouste (2019) Confidence interval for the mean time to
failure in semi-Markov models: an application to wind energy production,
Journal of Applied Statistics, 46:10, 1756-1773.
}
\author{
\strong{Maintainer}: Nicolas Vergne \email{nicolas.vergne@univ-rouen.fr}

Authors:
\itemize{
  \item Vlad Stefan Barbu (\href{https://orcid.org/0000-0002-0840-016X}{ORCID})
  \item Caroline Berard
  \item Dominique Cellier
  \item Florian Lecocq
  \item Corentin Lothode
  \item Mathilde Sautreuil
}

}
\keyword{Markov}
\keyword{availability}
\keyword{censored}
\keyword{estimation}
\keyword{failure}
\keyword{maintainability}
\keyword{reliability}
\keyword{semi-Markov}
\keyword{simulation}
