% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sof.michalewicz.R
\name{makeMichalewiczFunction}
\alias{makeMichalewiczFunction}
\title{Michalewicz Function}
\usage{
makeMichalewiczFunction(dimensions, m = 10)
}
\arguments{
\item{dimensions}{[\code{integer(1)}]\cr
Size of corresponding parameter space.}

\item{m}{[\code{integer(1)}]\cr
\dQuote{Steepness} parameter.}
}
\value{
[\code{smoof_single_objective_function}]
}
\description{
Highly multimodal single-objective test function with \eqn{n!} local minima
with the formula:
\deqn{f(\mathbf{x}) = -\sum_{i=1}^{n} \sin(\mathbf{x}_i) \cdot \left(\sin\left(\frac{i \cdot \mathbf{x}_i}{\pi}\right)\right)^{2m}.}
The recommended value \eqn{m = 10}, which is used as a default in the
implementation.
}
\note{
The location of the global optimum s varying based on both
the dimension and \eqn{m} parameter and is thus not provided in the
implementation.
}
\references{
Michalewicz, Z.: Genetic Algorithms + Data Structures = Evolution
Programs. Berlin, Heidelberg, New York: Springer-Verlag, 1992.
}
