% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getWrappedFunction.R
\name{getWrappedFunction}
\alias{getWrappedFunction}
\title{Extract wrapped function.}
\usage{
getWrappedFunction(fn, deepest = FALSE)
}
\arguments{
\item{fn}{[\code{smoof_wrapped_function}]\cr
Wrapping function.}

\item{deepest}{[\code{logical(1)}]\cr
Function may be wrapped with multiple wrappers. If \code{deepest} is set to
\code{TRUE} the function unwraps recursively until the \dQuote{deepest} wrapped
\code{smoof_function} is reached. Default is \code{FALSE}.}
}
\value{
[\code{function}]
}
\description{
The \pkg{smoof} package offers means to let a function log its evaluations or
even store to points and function values it has been evaluated on. This is done
by wrapping the function with other functions. This helper function extract
the wrapped function.
}
\note{
If this function is applied to a simple \code{smoof_function}, the
\code{smoof_function} itself is returned.
}
\seealso{
\code{\link{addCountingWrapper}}, \code{\link{addLoggingWrapper}}
}
