% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ves.R
\name{ves}
\alias{ves}
\title{NOT AVAILABLE YET: Vector Exponential Smoothing in SSOE state-space model}
\usage{
ves(data, model = "ANN", persistence = c("individual", "group"),
  transition = c("individual", "group"), measurement = c("individual",
  "group"), initial = c("individual", "group"),
  initialSeason = c("individual", "group"), cfType = c("MSE", "MAE", "HAM",
  "GMSTFE", "MSTFE", "MSEh", "TFL"), ic = c("AICc", "AIC", "BIC"), h = 10,
  holdout = FALSE, intervals = c("none", "parametric", "semiparametric",
  "nonparametric"), level = 0.95, intermittent = c("none", "auto", "fixed",
  "croston", "tsb", "sba"), bounds = c("usual", "admissible", "none"),
  silent = c("none", "all", "graph", "legend", "output"), xreg = NULL,
  xregDo = c("use", "select"), initialX = NULL, updateX = FALSE,
  persistenceX = NULL, transitionX = NULL, ...)
}
\arguments{
\item{data}{is the matrix with data, where series are in columns and
observations are in rows.}

\item{model}{The type of ETS model. Can consist of 3 or 4 chars: \code{ANN},
\code{AAN}, \code{AAdN}, \code{AAA}, \code{AAdA}, \code{MAdM} etc.
\code{ZZZ} means that the model will be selected based on the chosen
information criteria type. ATTENTION! NO MODEL SELECTION IS AVAILABLE AT
THIS STAGE!

Also \code{model} can accept a previously estimated VES model and use all its
parameters.

Keep in mind that model selection with "Z" components uses Branch and Bound
algorithm and may skip some models that could have slightly smaller
information criteria.}

\item{persistence}{Persistence vector \eqn{g}, containing smoothing
parameters. Can either be \code{individual} for each series or \code{group},
equal to all the time series. If a value is provided, then it is used by the model.}

\item{transition}{Transition matrix \eqn{F}. Can either be \code{individual} for
each series or \code{group}, equal to all the time series. If vector or a matrix
is provided here, then it is used by the model.}

\item{measurement}{Measurement vector \eqn{w}. Can either be \code{individual} for
each series or \code{group}, equal to all the time series. If vector is provided
here, then it is used by the model.}

\item{initial}{Can be either character or a vector / matrix of initial states.
If it is character, then it can be \code{"individual"}, individual values of
the intial non-seasonal components are udes, or \code{"group"}, meaning that
the initials for all the time series are set to be equal to the same value.
If vector of states is provided, then it is automatically transformed into
a matrix, assuming that these values are provided for the whole group.}

\item{initialSeason}{Can be either character or a vector / matrix of initial
states. Treated the same way as \code{initial}. This means that different time
series may share the same initial seasonal component.}

\item{cfType}{Type of Cost Function used in optimization. \code{cfType} can
be: \code{MSE} (Mean Squared Error), \code{MAE} (Mean Absolute Error),
\code{HAM} (Half Absolute Moment), \code{GMSTFE} - Mean Log Squared Trace
Forecast Error, \code{MSTFE} - Mean Squared Trace Forecast Error and
\code{MSEh} - optimisation using only h-steps ahead error, \code{TFL} -
trace forecast likelihood. If \code{cfType!="MSE"}, then likelihood and
model selection is done based on equivalent \code{MSE}. Model selection in
this cases becomes not optimal.

There are also available analytical approximations for multistep functions:
\code{aMSEh}, \code{aMSTFE} and \code{aGMSTFE}. These can be useful in cases
of small samples.}

\item{ic}{The information criterion used in the model selection procedure.}

\item{h}{Length of forecasting horizon.}

\item{holdout}{If \code{TRUE}, holdout sample of size \code{h} is taken from
the end of the data.}

\item{intervals}{Type of intervals to construct. This can be:

\itemize{
\item \code{none}, aka \code{n} - do not produce prediction
intervals.
\item \code{parametric}, \code{p} - use state-space structure of ETS. In
case of mixed models this is done using simulations, which may take longer
time than for the pure additive and pure multiplicative models.
\item \code{semiparametric}, \code{sp} - intervals based on covariance
matrix of 1 to h steps ahead errors and assumption of normal / log-normal
distribution (depending on error type).
\item \code{nonparametric}, \code{np} - intervals based on values from a
quantile regression on error matrix (see Taylor and Bunn, 1999). The model
used in this process is e[j] = a j^b, where j=1,..,h.
}
The parameter also accepts \code{TRUE} and \code{FALSE}. Former means that
parametric intervals are constructed, while latter is equivalent to
\code{none}.}

\item{level}{Confidence level. Defines width of prediction interval.}

\item{intermittent}{Defines type of intermittent model used. Can be: 1.
\code{none}, meaning that the data should be considered as non-intermittent;
2. \code{fixed}, taking into account constant Bernoulli distribution of
demand occurancies; 3. \code{croston}, based on Croston, 1972 method with
SBA correction; 4. \code{tsb}, based on Teunter et al., 2011 method. 5.
\code{auto} - automatic selection of intermittency type based on information
criteria. The first letter can be used instead. 6. \code{"sba"} -
Syntetos-Boylan Approximation for Croston's method (bias correction)
discussed in Syntetos and Boylan, 2005.}

\item{bounds}{What type of bounds to use in the model estimation. The first
letter can be used instead of the whole word.}

\item{silent}{If \code{silent="none"}, then nothing is silent, everything is
printed out and drawn. \code{silent="all"} means that nothing is produced or
drawn (except for warnings). In case of \code{silent="graph"}, no graph is
produced. If \code{silent="legend"}, then legend of the graph is skipped.
And finally \code{silent="output"} means that nothing is printed out in the
console, but the graph is produced. \code{silent} also accepts \code{TRUE}
and \code{FALSE}. In this case \code{silent=TRUE} is equivalent to
\code{silent="all"}, while \code{silent=FALSE} is equivalent to
\code{silent="none"}. The parameter also accepts first letter of words ("n",
"a", "g", "l", "o").}

\item{xreg}{Vector (either numeric or time series) or matrix (or data.frame)
of exogenous variables that should be included in the model. If matrix
included than columns should contain variables and rows - observations. Note
that \code{xreg} should have number of observations equal either to
in-sample or to the whole series. If the number of observations in
\code{xreg} is equal to in-sample, then values for the holdout sample are
produced using \link[smooth]{es} function.}

\item{xregDo}{Variable defines what to do with the provided xreg:
\code{"use"} means that all of the data should be used, whilie
\code{"select"} means that a selection using \code{ic} should be done.
\code{"combine"} will be available at some point in future...}

\item{initialX}{Vector of initial parameters for exogenous variables.
Ignored if \code{xreg} is NULL.}

\item{updateX}{If \code{TRUE}, transition matrix for exogenous variables is
estimated, introducing non-linear interractions between parameters.
Prerequisite - non-NULL \code{xreg}.}

\item{persistenceX}{Persistence vector \eqn{g_X}, containing smoothing
parameters for exogenous variables. If \code{NULL}, then estimated.
Prerequisite - non-NULL \code{xreg}.}

\item{transitionX}{Transition matrix \eqn{F_x} for exogenous variables. Can
be provided as a vector. Matrix will be formed using the default
\code{matrix(transition,nc,nc)}, where \code{nc} is number of components in
state vector. If \code{NULL}, then estimated. Prerequisite - non-NULL
\code{xreg}.}

\item{...}{Other non-documented parameters. For example \code{FI=TRUE} will
make the function also produce Fisher Information matrix, which then can be
used to calculated variances of smoothing parameters and initial states of
the model.
Parameters \code{C}, \code{CLower} and \code{CUpper} can be passed via
ellipsis as well. In this case they will be used for optimisation. \code{C}
sets the initial values before the optimisation, \code{CLower} and
\code{CUpper} define lower and upper bounds for the search inside of the
specified \code{bounds}. These values should have exactly the length equal
to the number of parameters to estimate.}
}
\value{
Object of class "smooth" is returned. It contains a list of
values.
}
\description{
Function constructs vector ETS model and returns forecast, fitted values, errors
and matrix of states along with other useful variables. THIS IS CURRENTLY UNDER CONSTRUCTION!
}
\details{
Function estimates vector ETS in a form of the Single Source of Error State-space
model of the following type:

\deqn{
\mathbf{y}_{t} = \mathbf{o}_{t} (\mathbf{W} \mathbf{v}_{t-l} + \mathbf{x}_t
\mathbf{a}_{t-1} + \mathbf{\epsilon}_{t})
}{
y_{t} = o_{t} (W v_{t-l} + x_t a_{t-1} + \epsilon_{t})
}

\deqn{
\mathbf{v}_{t} = \mathbf{F} \mathbf{v}_{t-l} + \mathbf{G}
\mathbf{\epsilon}_{t}
}{
v_{t} = F v_{t-l} + G \epsilon_{t}
}

\deqn{\mathbf{a}_{t} = \mathbf{F_{X}} \mathbf{a}_{t-1} + \mathbf{G_{X}}
\mathbf{\epsilon}_{t} / \mathbf{x}_{t}}{a_{t} = F_{X} a_{t-1} + G_{X} \epsilon_{t}
/ x_{t}}

Where \eqn{y_{t}} is the vector of time series on observation \eqn{t}, \eqn{o_{t}}
is the vector of Bernoulli distributed random variable (in case of normal data it
becomes unit vector for all observations), \eqn{\mathbf{v}_{t}} is the matrix of
states and \eqn{l} is the matrix of lags, \eqn{\mathbf{x}_t} is the vector of
exogenous variables. \eqn{\mathbf{W}} is the measurement matrix, \eqn{\mathbf{F}}
is the transition matrix and \eqn{\mathbf{G}} is the persistence matrix.
Finally, \eqn{\epsilon_{t}} is the vector of error terms.

Conventionally we formulate values as:

\deqn{\mathbf{y}'_t = (y_{1,t}, y_{2,t}, \dots, y_{m,t})}{y_t = (y_{1,t}, y_{2,t},
\dots, y_{m,t}),}
where \eqn{m} is the number of series in the group.
\deqn{\mathbf{v}'_t = (v_{1,t}, v_{2,t}, \dots, v_{m,t})}{v'_t = (v_{1,t}, v_{2,t},
\dots, v_{m,t}),}
where \eqn{v_{i,t}} is vector of components for i-th time series.
\deqn{\mathbf{W}' = (w_{1}, \dots , 0;
\vdots , \ddots , \vdots;
0 , \vdots , w_{m})}{W' = (w_{1}, ... , 0;
... , ... , ...;
0 , ... , w_{m})} is matrix of measurement vectors.

For the details see Hyndman et al. (2008), chapter 17.
}
\examples{

library(Mcomp)

\dontrun{es(M3$N2568$x,model="MAM",h=18,holdout=TRUE)}


}
\references{
\itemize{
\item Snyder, R. D., 1985. Recursive Estimation of Dynamic Linear Models.
Journal of the Royal Statistical Society, Series B (Methodological) 47 (2), 272-276.
\item Hyndman, R.J., Koehler, A.B., Ord, J.K., and Snyder, R.D. (2008)
Forecasting with exponential smoothing: the state space approach,
Springer-Verlag. \url{http://www.exponentialsmoothing.net}.
}

\itemize{
\item Teunter R., Syntetos A., Babai Z. (2011). Intermittent demand:
Linking forecasting to inventory obsolescence. European Journal of
Operational Research, 214, 606-615.
\item Croston, J. (1972) Forecasting and stock control for intermittent
demands. Operational Research Quarterly, 23(3), 289-303.
\item Syntetos, A., Boylan J. (2005) The accuracy of intermittent demand
estimates. International Journal of Forecasting, 21(2), 303-314.
}

\itemize{
\item Kolassa, S. (2011) Combining exponential smoothing forecasts using Akaike
weights. International Journal of Forecasting, 27, pp 238 - 251.
}

\itemize{
\item Taylor, J.W. and Bunn, D.W. (1999) A Quantile Regression Approach to
Generating Prediction Intervals. Management Science, Vol 45, No 2, pp
225-237.
}
}
\seealso{
\code{\link[smooth]{es}, \link[forecast]{ets},
\link[forecast]{forecast}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{smooth}
\keyword{ts}
\keyword{univar}
