% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adam.R, R/methods.R, R/msdecompose.R
\name{forecast.adam}
\alias{forecast.adam}
\alias{forecast.smooth}
\alias{forecast}
\alias{forecast.oes}
\alias{forecast.msdecompose}
\title{Forecasting time series using smooth functions}
\usage{
\method{forecast}{adam}(object, h = 10, newdata = NULL,
  occurrence = NULL, interval = c("none", "prediction", "confidence",
  "simulated", "approximate", "semiparametric", "nonparametric", "empirical",
  "complete"), level = 0.95, side = c("both", "upper", "lower"),
  cumulative = FALSE, nsim = NULL, scenarios = FALSE, ...)

\method{forecast}{smooth}(object, h = 10, interval = c("parametric",
  "semiparametric", "nonparametric", "none"), level = 0.95,
  side = c("both", "upper", "lower"), ...)

\method{forecast}{oes}(object, h = 10, ...)

\method{forecast}{msdecompose}(object, h = 10, interval = c("parametric",
  "semiparametric", "nonparametric", "none"), level = 0.95, model = NULL,
  ...)
}
\arguments{
\item{object}{Time series model for which forecasts are required.}

\item{h}{Forecast horizon.}

\item{newdata}{The new data needed in order to produce forecasts.}

\item{occurrence}{The vector containing the future occurrence variable
(values in [0,1]), if it is known.}

\item{interval}{What type of mechanism to use for interval construction.
the recommended option is \code{interval="prediction"}, which will use analytical
solutions for pure additive models and simulations for the others.
\code{interval="simulated"} is the slowest method, but is robust to the type of
model. \code{interval="approximate"} (aka \code{interval="parametric"}) uses
analytical formulae for conditional h-steps ahead variance, but is approximate
for the non-additive error models. \code{interval="semiparametric"} relies on the
multiple steps ahead forecast error (extracted via \code{rmultistep} method) and on
the assumed distribution of the error term. \code{interval="nonparametric"} uses
Taylor & Bunn (1999) approach with quantile regressions. \code{interval="empirical"}
constructs intervals based on empirical quantiles of multistep forecast errors.
\code{interval="complete"} will call for \code{reforecast()} function and produce
interval based on the uncertainty around the parameters of the model.
Finally, \code{interval="confidence"} tries to generate the confidence intervals
for the point forecast based on the \code{reforecast} method.}

\item{level}{Confidence level. Defines width of prediction interval.}

\item{side}{Defines, whether to provide \code{"both"} sides of prediction
interval or only \code{"upper"}, or \code{"lower"}.}

\item{cumulative}{If \code{TRUE}, then the cumulative forecast and prediction
interval are produced instead of the normal ones. This is useful for
inventory control systems.}

\item{nsim}{Number of iterations to do in cases of \code{interval="simulated"},
\code{interval="prediction"} (for mixed and multiplicative model),
\code{interval="confidence"} and \code{interval="complete"}.
The default value for the prediction / simulated interval is 1000. In case of
confidence or complete intervals, this is set to 100.}

\item{scenarios}{Binary, defining whether to return scenarios produced via
simulations or not. Only works if \code{interval="simulated"}. If \code{TRUE}
the object will contain \code{scenarios} variable.}

\item{...}{Other arguments accepted by either \link[smooth]{es},
\link[smooth]{ces}, \link[smooth]{gum} or \link[smooth]{ssarima}.}

\item{model}{The type of ETS model to fit on the decomposed trend. Only applicable to
"msdecompose" class. This is then returned in parameter "esmodel". If \code{NULL}, then
it will be selected automatically based on the type of the used decomposition (either
among pure additive or among pure multiplicative ETS models).}
}
\value{
Returns object of class "smooth.forecast", which contains:

\itemize{
\item \code{model} - the estimated model (ES / CES / GUM / SSARIMA).
\item \code{method} - the name of the estimated model (ES / CES / GUM / SSARIMA).
\item \code{forecast} aka \code{mean} - point forecasts of the model
(conditional mean).
\item \code{lower} - lower bound of prediction interval.
\item \code{upper} - upper bound of prediction interval.
\item \code{level} - confidence level.
\item \code{interval} - binary variable (whether interval were produced or not).
\item \code{scenarios} - in case of \code{forecast.adam()} and
\code{interval="simulated"} returns matrix with scenarios (future paths) that were
used in simulations.
}
}
\description{
Function produces conditional expectation (point forecasts) and prediction
intervals for the estimated model.
}
\details{
By default the function will generate conditional expectations from the
estimated model and will also produce a variety of prediction intervals
based on user preferences.
}
\examples{

ourModel <- ces(rnorm(100,0,1),h=10)

forecast(ourModel,h=10)
forecast(ourModel,h=10,interval=TRUE)
plot(forecast(ourModel,h=10,interval=TRUE))

}
\references{
Hyndman, R.J., Koehler, A.B., Ord, J.K., and Snyder, R.D. (2008)
Forecasting with exponential smoothing: the state space approach,
Springer-Verlag.
}
\seealso{
\code{\link[generics]{forecast}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{ts}
\keyword{univar}
