% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothic_functions.R
\name{smoothic}
\alias{smoothic}
\title{Variable Selection Using a Smooth Information Criterion (SIC)}
\usage{
smoothic(
  formula,
  data,
  model = "mpr",
  lambda = "log(n)",
  epsilon_1 = 10,
  epsilon_T = 1e-05,
  steps_T = 100,
  zero_tol = 1e-08,
  tol = 1e-08,
  max_it = 10000,
  initial_step = 10,
  max_step_it = 1000
)
}
\arguments{
\item{formula}{An object of class \code{"\link{formula}"}: a two-sided object
with response on the left hand side and the model variables on the right hand side.}

\item{data}{A data frame containing the variables in the model; the data frame
should be unstandardized.}

\item{model}{The type of regression to be implemented, either \code{model = "mpr"}
for multi-parameter regression, or \code{model = "spr"} for single parameter
regression (i.e., classical normal linear regression). Defaults to \code{model="mpr"}.}

\item{lambda}{Value of penalty tuning parameter. Suggested values are
\code{"log(n)"} and \code{"2"} for the BIC and AIC respectively. Defaults to
\code{lambda ="log(n)"} for the BIC case.}

\item{epsilon_1}{Starting value for \eqn{\epsilon}-telescope. Defaults to 10.}

\item{epsilon_T}{Final value for \eqn{\epsilon}-telescope. Defaults to
\code{1e-05}.}

\item{steps_T}{Number of steps in \eqn{\epsilon}-telescope. Defaults to 100.}

\item{zero_tol}{Coefficients below this value are treated as being zero.
Defaults to \code{1e-08}.}

\item{tol}{Convergence tolerance for the optimization. Defaults to
\code{1e-08}.}

\item{max_it}{Maximum number of iterations to performed before the
optimization is terminated. Defaults to \code{1e+04}.}

\item{initial_step}{Initial step length for step halving in Newton-Raphson
algorithm. Defaults to 10.}

\item{max_step_it}{Maximum allowable number of steps to take for step
halving in Newton-Raphson algorithm. Defaults to \code{1e+03}.}
}
\value{
A list with estimates and estimated standard errors.
\itemize{
  \item \code{coefficients} - vector of coefficients.
  \item \code{see} - vector of estimated standard errors.
  \item \code{model} - the matched type of model which is called.
  \item \code{plike} - value of the penalized likelihood function.
  }
}
\description{
Implements the SIC \eqn{\epsilon}-telescope method, either using
single or multi-parameter regression. Returns estimated coefficients, estimated
standard errors (SEE) and the value of the penalized likelihood function.
Note that the function will scale the predictors to have unit variance, however,
the final estimates are converted back to their original scale.
}
\examples{
# Sniffer Data --------------------
# MPR Model ----
results <- smoothic(
  formula = y ~ .,
  data = sniffer,
  model = "mpr"
)
summary(results)

}
\references{
O'Neill, M. and Burke, K. (2021) Variable Selection Using a Smooth
Information Criterion for Multi-Parameter Regression Models. <arXiv:2110.02643>
}
\author{
Meadhbh O'Neill
}
