% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bostonhouseprice2}
\alias{bostonhouseprice2}
\title{Boston House Price Data (Corrected Version)}
\format{
A data frame with 506 rows and 13 variables:
\describe{
   \item{crim}{per capita crime rate by town}
   \item{zn}{proportion of residential land zoned for lots over 25,000 sq.ft}
   \item{indus}{proportion of non-retail business acres per town}
   \item{rm}{average number of rooms per dwelling}
   \item{age}{proportion of owner-occupied units built prior to 1940}
   \item{rad}{index of accessibility to radial highways}
   \item{ptratio}{pupil-teacher ratio by town}
   \item{lnox}{log(nitric oxides concentration (parts per 10 million))}
   \item{ldis}{log(weighted distances to five Boston employment centres)}
   \item{ltax}{log(full-value property-tax rate per USD 10,000)}
   \item{llstat}{log(percentage of lower status of the population)}
   \item{chast}{Charles River dummy variable (=1 if tract bounds river; 0 otherwise)}
   \item{lcmedv}{log(corrected median value of owner-occupied homes in USD 1000's)}
   }
}
\source{
\url{https://CRAN.R-project.org/package=mlbench}
}
\usage{
bostonhouseprice2
}
\description{
Corrected data, which come from a study by Harrison Jr and Rubinfeld (1978), examining
the association between median house prices in a particular community with
various community characteristics. See \code{\link{bostonhouseprice}} for the
original version.
}
\references{
Harrison Jr, D. and Rubinfeld, D. L. (1978). Hedonic housing prices and the
demand for clean air. Journal of environmental economics and management, 5(1):81-102.

Leisch F, Dimitriadou E (2021). mlbench: Machine Learning Benchmark Problems. R package version 2.1-3.
}
\keyword{datasets}
