% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densify.r
\name{densify}
\alias{densify}
\title{Densify spatial lines or polygons}
\usage{
densify(x, n = 10L, max_distance)
}
\arguments{
\item{x}{spatial features; lines or polygons from either the \code{sf} or \code{sp}
packages.}

\item{n}{integer; number of times to split each line segment. Ignored if
\code{max_distance} is specified.}

\item{max_distance}{numeric; the maximum distance between vertices in the
resulting matrix. This is the Euclidean distance and not the great circle
distance.}
}
\value{
A densified polygon or line in the same format as the input data.
}
\description{
A wrapper for \code{smooth(x, method = "densify")}. This function adds additional
vertices to spatial feature via linear interpolation, always while keeping
the original vertices. Each line segment will be split into equal length
sub-segments. This densification algorithm treats all vertices as Euclidean
points, i.e. new points will not fall on a great circle between existing
vertices, rather they'll be along a straight line.
}
\examples{
library(sf)
l <- jagged_lines$geometry[[2]]
l_dense <- densify(l, n = 2)
plot(l, lwd = 5)
plot(l_dense, col = "red", lwd = 2, lty = 2, add = TRUE)
plot(l_dense \%>\% st_cast("MULTIPOINT"), col = "red", pch = 19,
     add = TRUE)
}
