\name{msn.affine}
\alias{msn.affine}
\alias{mst.affine}
\title{
  Affine transformation a multivariate skew-normal or
  skew-t variable
}
\description{
  Computes the parameters of an affine transformation \emph{a+ A Y}
  of a multivariate skew-normal or skew-t variable \emph{Y}
}
\usage{
  msn.affine(dp, a=0, A, drop=TRUE)
  mst.affine(dp, a=0, A, drop=TRUE)
}
\arguments{
  \item{dp}{a list containg the pamaters of the variable being
    transformed; it must include components \code{xi}, \code{Omega},
    \code{alpha} as described for \code{dmsn}; for \code{mst.affine},
    also a component \code{df} is expected
  }
  \item{A}{a matrix with \code{ncol(A)} equal to \code{nrow(dp$Omega)}
  }
  \item{a}{a vector wiht \code{length(a)} equal to \code{nrow(dp$Omega)}
  }
  \item{drop}{a logical flag (default value is \code{TRUE}) operating when 
    \code{nrow(A)} equals 1. If these conditions are met, the output
    is provided in the form of parameters of a scalar distribution,
    \code{dsn} or \code{dst}, depending in the case.
  }
}
\value{
  A list containing the same components of the input parameter \code{dp}
  }
\section{Background}{
  For background information about the skew-normal and skew-t
  distributions, their parameters and the properties of affine
  transformations, see the references below.
}
\references{
Azzalini, A. and Capitanio, A. (1999).
Statistical applications of the multivariate skew-normal distribution.
\emph{J.Roy.Statist.Soc. B} \bold{61}, 579--602.

Azzalini, A. and Capitanio, A. (2003).
Distributions generated by perturbation of symmetry 
with emphasis on a multivariate skew-\emph{t} distribution.
\emph{J.Roy. Statist. Soc. B} \bold{65}, 367--389.

Capitanio, A. \emph{et al.} (2003).
Graphical models for skew-normal variates.
\emph{Scand.\ J.\ Statist.} \bold{30}, 129--144.

}
\seealso{
\code{\link{dsn}}, \code{\link{dst}}, \code{\link{dmsn}}, \code{\link{dmst}}
}
\examples{
dp<- list(xi=c(1,1,2), Omega=toeplitz(1/1:3), alpha=c(3,-1,2))
A <- matrix(c(1,-1,1,3,0,-2), 2, 3, byrow=TRUE) 
dp1 <- msn.affine(dp, 1:2, A)
#
dp$df <- 5
dp2<-  mst.affine(dp,,A[1,,drop=FALSE])
dp3<-  mst.affine(dp,,A[1,,drop=FALSE], drop=FALSE)
if(zapsmall(dp2$scale^2 - dp3$Omega)) print("something wrong here!")
}
\keyword{multivariate}
\keyword{distribution}
