\name{sn.mle.grouped}
\alias{sn.mle.grouped}
\alias{st.mle.grouped}
\title{
Maximum likelihood estimation of SN and ST distribution for grouped data 
}
\description{
Fits a skew-normal (SN) and skew-t (ST) distribution to grouped data 
using exact maximum likelihood estimation
}
\usage{
sn.mle.grouped(breaks, freq, trace=FALSE, start=NA)
st.mle.grouped(breaks, freq, trace=FALSE, start=NA)
}
\arguments{
\item{breaks}{
a vector contaning the cut points of the groups, given
in ascending order. The last value can be \code{Inf}, the
first one can be \code{-Inf}}
\item{freq}{
a vector containing the observed frequencies corresponding to
the intervals defined by \code{breaks}; it is required
that \code{length(freq)=length(breaks)-1}
}
\item{trace}{
logical value which controls printing of the algorithm convergence.
If \code{trace=TRUE}, details are printed. Default value is \code{FALSE}
}
\item{start}{
vector of length  with initial values for the woking parameters:
location, log(scale), shape and (for the ST case) log(df).
}}
\value{
a list containing the following components:

\item{call}{
  a string containing the calling statement
}
\item{dp}{
  for the SN case, a vector of length 3 containing the location, scale
  and shape parameter; for the ST case, there is an extra parameter, the
  degress of freedom
}
\item{end}{
  a vector of length 3 or 4 containing the working parameters; this
  vector can be used as a \code{start} for a new call to the function
}
\item{opt}{
  the list returned by the optimizer \code{optim}; see the documentation
  of this function for explanation of its components.
}}
\details{
  The optimizer \code{optim} is used, supplying  the log-likelihood
  function for grouped data, namely the  multinomial expression whose
  probabilities are assigned by the SN or ST distribution to the given
  intervals.
}
\section{Background}{
Background information on the SN distribution is given by Azzalini (1985);
see also Azzalini and Capitanio (1999). For the ST distribution, see
Azzalini and Capitanio (2003).
}
\references{
Azzalini, A. (1985).
A class of distributions which includes the normal ones.
\emph{Scand. J. Statist.} \bold{12}, 171-178.


Azzalini, A. and Capitanio, A. (1999).
Statistical applications of the multivariate skew-normal distribution.
\emph{J.Roy.Statist.Soc. B} \bold{61}, 579--602.

Azzalini, A. and Capitanio, A. (2003).
Distributions generated by perturbation of symmetry 
with emphasis on a multivariate skew-\emph{t} distribution.
\emph{J.Roy. Statist. Soc. B} \bold{65}, 367--389.

}
\seealso{
\code{\link{dsn}},  \code{\link{dst}}, \code{\link{optim}}, \code{\link{sn.mle}}
}
\examples{
data(ais, package="sn")
attach(ais)
breaks<- c(130,160, seq(170, 190, by=2.5), 200, 230)
f <- cut(Ht[sex=="female"], breaks = breaks)
freq <- tabulate(f, length(levels(f)))
b1 <- sn.mle.grouped(breaks, freq)
b2 <- st.mle.grouped(breaks, freq, start=c(b1$end,log(5)))
print(b2$dp)
#
us.income <- c(0,seq(from=0.2, to=1.8, by=0.1), 2.0, 2.5, 5.0, Inf)
mid <- (us.income[-1]+us.income[-length(us.income)])/2
mid[length(mid)] <- 6.5
cum.freq<- c(1.78, 3.25, 5.56, 8.16, 11.12, 14.21, 17.54, 20.78, 24.00,
             27.52, 30.77, 34.21, 37.56, 40.70, 44.41, 47.85, 51.22, 
             57.60, 72.12, 96.40, 100) / 100
freq<- round(diff(c(0,cum.freq*34660)))
a <- st.mle.grouped(breaks=log(us.income), freq, trace=TRUE,
        start=c(1.2, log(0.9), -2.1, log(20)))
print(a$dp)
}

\keyword{distribution}

