% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sk_index.R
\name{sk_vec2mat}
\alias{sk_vec2mat}
\title{Invert column-vectorization indices}
\usage{
sk_vec2mat(k, gdim, out = "matrix")
}
\arguments{
\item{k}{a vector of positive integers, the vector indices to look up}

\item{gdim}{integer (or vector with first element equal to) the number of rows in the matrix}

\item{out}{either 'matrix' or 'list'}
}
\value{
a two column matrix of integers (row and column numbers) with \code{length(k)} rows
}
\description{
Inverts the function \code{sk_mat2vec}, returning matrix row and column numbers i, j,
given the column-vectorized index \code{k} and matrix dimensions \code{gdim}.
}
\details{
Output indices are returned in a matrix with columns 'i', 'j' and rows in same
order as the input \code{k}. When \code{out='list'} list of vectors 'i' and 'j' (with entries
in the same order) is returned instead.

The entries of \code{k} can be any permutation with replacement from \code{seq(prod(gdim))}
}
\examples{

# show how elements are ordered in `base::matrix`
gdim = c(5, 6)
matrix_order = matrix(1:prod(gdim), gdim)
print(matrix_order)

# identify the row and column numbers for specific entry, or several
sk_vec2mat(2, gdim)
sk_vec2mat(c(2, 10, 5), gdim)
sk_vec2mat(c(2, 10, 5), gdim, out='list')

}
\seealso{
Other indexing functions: 
\code{\link{sk_mat2vec}()},
\code{\link{sk_rescale}()},
\code{\link{sk_sub_find}()},
\code{\link{sk_sub_idx}()}
}
\concept{indexing functions}
\keyword{internal}
