% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snpAIMeR_v2.1.0.R
\name{snpAIMeR}
\alias{snpAIMeR}
\title{Assess the Diagnostic Power of Genomic Marker Combinations}
\usage{
snpAIMeR(run_mode, config_file = NULL, verbose = TRUE)
}
\arguments{
\item{run_mode}{Modes are "interactive" or "non-interactive"; must be in quotes.}

\item{config_file}{Yaml file required for "non-interactive" mode; filename/path
must be in quotes.}

\item{verbose}{Default is TRUE.}
}
\value{
Average correct cross-validation assignment rates for individual
markers, marker combinations, and panel sizes. Outputs three .csv and two
.pdf files to a user-specified directory.
}
\description{
Population genetics package for designing diagnostic panels. Candidate
markers, marker combinations, and different panel sizes are assessed for how
well they can predict the source population of known samples. Requires a
genotype file of candidate markers in STRUCTURE format.
}
\details{
Yaml file format for "non-interactive" mode (do not include bullet points):
\itemize{
  \item min_range: <minimum panel size>
  \item max_range: <maximum panel size; we recommend no more than 15 markers>
  \item assignment_rate_threshold: <value from 0 to 1>
  \item cross_validation_replicates: <we recommend 100 minimum>
  \item working_directory: <path name in quotes>
  \item structure_file: <path name in quotes>
  \item number_of_individuals: <same as adegenet's "n.ind">
  \item number_of_loci: <same as adegenet's "n.loc">
  \item one_data_row_per_individual: <TRUE or FALSE>
  \item column_sample_IDs: <column number with individual sample names>
  \item column_population_assignments: <column number with population
  assignment>
  \item column_other_info: <column number>
  \item row_markernames: <row number with marker names>
  \item no_genotype_character: <default is "-9">
  \item optional_population_info: <optional>
  \item genotype_character_separator: <optional>
}

Minimizing run time: Because of the number of possible combinations, we
recommend testing no more than 15 markers. For example, testing 15 markers
in panel sizes of 1 to 15 (32,767 total combinations) with 1,000
cross-validation replicates on a system with 48 processor cores took about 5
hours and 20 GB RAM. Reducing the number of cross-validation replicates also
reduces run time, however, we recommend no less than 100 replicates.
}
\examples{
# In "example" mode only the individual marker assignment rate plot is generated.
if (requireNamespace("adegenet", quietly = TRUE)) {
  data(nancycats, package = "adegenet")
  snpAIMeR("example", verbose = TRUE)
}

}
\seealso{
https://github.com/OksanaVe/snpAIMeR
}
