% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_snp_to_gene.R
\name{map_snp_to_gene}
\alias{map_snp_to_gene}
\title{Map SNPs to genes}
\usage{
map_snp_to_gene(
  info_snp,
  info_gene,
  extend_start = 20L,
  extend_end = 20L,
  only_sets = FALSE
)
}
\arguments{
\item{info_snp}{A data frame with columns: "id", "chr", and "pos".
\itemize{
\item id = SNP ID (e.g., rs numbers)
\item chr = chromosome
\item pos = base-pair position
}}

\item{info_gene}{A data frame with columns: "gene.id", "chr", "start",
and "end".
\itemize{
\item gene.id = gene ID (or identifier for genomic regions)
\item chr = chromosome (must be the same chromosome coding scheme in \code{info_snp})
\item start = genomic start position
\item end = genomic end position
}

If a gene has multiple intervals, SNPs mapped to any of them will be merged
into a single set. Please assign unique IDs if you don't want this behavior.}

\item{extend_start}{A single non-negative integer, allowing for a certain kb
window before the gene to be included. Default is 20 (= 20kb).}

\item{extend_end}{A single non-negative integer, allowing for a certain kb
window after the gene to be included. Default is 20 (= 20kb).}

\item{only_sets}{If \code{TRUE}, only sets of SNPs for individual genes are
returned. Otherwise, both sets and mapping information are returned.
Default is \code{FALSE}.}
}
\value{
A nested list containing following components:
\itemize{
\item sets: a named list where each index represents a separate set of SNPs
\item map: a data frame containing SNP mapping information
}
}
\description{
Annotate SNPs onto their neighboring genes (or arbitrary genomic regions) to
perform set-based association tests.
}
\examples{
## GWAS summary statistics
head(exGWAS)

## Gene information data
head(gene.curated.GRCh37)

## Map SNPs to genes
snp_sets <- map_snp_to_gene(exGWAS, gene.curated.GRCh37)

## Better to use harmonized GWAS data for gene mapping
bfile <- system.file("extdata", "example.bed", package = "snpsettest")
x <- read_reference_bed(path = bfile)
hsumstats <- harmonize_sumstats(exGWAS, x)
snp_sets <- map_snp_to_gene(hsumstats, gene.curated.GRCh37)

}
